@extends('gear::layouts.master')
@section('content')
  <!-- Blog Section Start -->
  <div class="blog-page-section">
    <div class="container">
      <div class="heading row">
        <div class="col-md-12 title">
          <h1>Our Blogs</h1>
        </div>
      </div>
      <div class="row">
        @foreach($results as $blog)
        <div class="col-md-4">
          <div class="post-inner">
            <div class="entry-media">
              <div class="post-cat">
                <span class="posted-in">
                    @foreach($blog->categories as $category)
                    <a href="{{route('post', $category->slug)}}">{{$category->title}}</a> 
                  @endforeach
                </span>
              </div>     
              @if($blog->hasFeaturedImage())         
              <a href="{{$blog->permalink()}}" class="image">
                <img src="{{$blog->featuredImage()}}">
              </a>
              @endif
            </div>
            <div class="inner-post">
              <div class="entry-header">
                <div class="entry-meta">
                  <span class="posted-on">
                    <a href="{{$blog->permalink()}}">{{$blog->date('M d, Y', 'created')}}</a>
                  </span>
                </div>
                <h3 class="entry-title">
                  <a href="{{$blog->permalink()}}">{{$blog->title}}</a>
                </h3>
              </div>
              
              <div class="btn-readmore">
                <a href="{{$blog->permalink()}}"><i class="fas fa-long-arrow-alt-right"></i> LEARN MORE</a>
              </div>
            </div>
          </div>
        </div>
        @endforeach
      </div>
      {{$results->links()}}
    </div>
  </div>
  <!-- Blog Section End -->
@endsection
