<?php

use Rawbinn\Media\Http\Controllers\MediaController;

Route::group(['prefix' =>'admin', 'middleware' => ['web', 'admin']], function(){
	
	Route::post('filemanager', [MediaController::class, 'show'])->name('admin.filemanager.show');
	Route::post('filemanager/upload', [MediaController::class, 'upload'])->name('admin.filemanager.upload');
	Route::get('filemanager/files', [MediaController::class, 'files'])->name('admin.filemanager.files');
	Route::post('filemanager/preview', [MediaController::class, 'preview'])->name('admin.filemanager.preview');
	Route::get('filemanager/download/{id}', [MediaController::class, 'download'])->name('admin.filemanager.download');
	Route::post('image/upload', [MediaController::class, 'imageUpload'])->name('admin.image.upload');
});

Route::get('image/{path}/{dimension?}', [MediaController::class, 'getCacheImage'])->where(['path' => '[a-zA-Z0-9/-]+\.\w{3}$'])->name('media.getcacheimage');