<?php namespace Rawbinn\Larapress;

use Illuminate\Support\Facades\Log;
use Illuminate\View\Compilers\BladeCompiler;
use Illuminate\Support\ServiceProvider as BaseServiceProvider;
use Illuminate\Support\Str;
use Theme;
use TorMorten\Eventy\Facades\Eventy;

/**
 * Class LarapressServieProvider
 * @package Rawbinn\Larapress
 * @author Rawbinn Shrestha <rawbinnn@gmail.com>
 */
class LarapressServiceProvider extends BaseServiceProvider {

	/**
	 * Indicates if loading of the provider is deferred.
	 *
	 * @var bool
	 */
	protected $defer = true;


	/**
	 * Bootstrap the application events.
	 *
	 * @return void
	 */
	public function boot()
	{
		include __DIR__.'/helpers.php';
		$routeConfig = [
			'namespace' => 'Rawbinn\Larapress\Controllers',
			'prefix' => '_larapress'
		];

		$this->getRouter()->group($routeConfig, function ($router) {
			
			$router->get('assets/stylesheets', [
				'uses' => 'AssetController@css',
				'as' => 'larapress.assets.css',
			]);

			$router->get('assets/javascript', [
				'uses' => 'AssetController@js',
				'as' => 'larapress.assets.js',
			]);
		});
		$this->registerMiddleware('Rawbinn\Larapress\Middleware\Larapress');
		// $this->registerLarapress();
		$this->registerThemeOptions();
		$this->registerMenus();
		$this->registerMailer();
		
	}

	public function registerMenus()
	{
		
		$menus = get_post_types();
		$formatedMenu = [];
		foreach($menus as $key => $menu) {
			$key = Str::slug(strtolower($key));
			if($menu['show_in_menu']) {
				
				$formatedMenu[] = [
						'key' => $key,
						'name' => $menu['labels']['menu_name'] ?? 'Item Undefined',
						'route' => 'admin/type/'.$key,
						'routes' => ['admin/type/'.$key],
						'sort' => $menu['menu_position'],
						'icon-class' => $menu['menu_icon'],
						'permission' => 'manage-custom-post-type'
				];
				$formatedMenu[] = [
						'key' => $key.'.all',
						'name' => $menu['labels']['all_items'] ?? 'All Item',
						'route' => 'admin/type/'.$key,
						'routes' => ['admin/type/'.$key],
						'sort' => 1,
						'icon-class' => 'far fa-circle nav-icon',
						'permission' => 'manage-custom-post-type'
				];
				$formatedMenu[] = [
						'key' => $key.'.add',
						'name' => $menu['labels']['add_new'] ?? 'Add Item',
						'route' => 'admin/type/'.$key.'/create',
						'routes' => ['admin/type/'.$key],
						'sort' => 2,
						'icon-class' => 'far fa-circle nav-icon',
						'permission' => 'manage-custom-post-type'
				];
				if(in_array('category', $menu['supports'])) {
					$formatedMenu[] = [
							'key' => $key.'.category',
							'name' => 'Category',
							'route' => 'admin/type/'.$key.'/category/create',
							'routes' => ['admin/type/'.$key.'/category/create'],
							'sort' => 3,
							'icon-class' => 'far fa-circle nav-icon',
							'permission' => 'manage-custom-post-type'
					];
				}
			}
		}

		$options = Eventy::filter('register_options', []);
		if(count($options)>0){
			$formatedMenu[] = [
				'key' => 'appearance.theme_options',
				'name' => 'Theme Options',
				'route' => 'admin.theme.options',
				'routes' => ['admin.theme.options'],
				'sort' => 3,
				'icon-class' => 'far fa-circle',
				'permission' => 'manage-theme-options'
				
			];
		}
		$this->app['config']->set('menu.admin', array_merge($formatedMenu, config('menu.admin')));
		
	}

	public function registerThemeOptions()
	{
		try {
			$theme = config('access.INSTALLED', false) ? setting('theme-active', config('themes.active')) : config('themes.active');
			$theme_path = Theme::getThemePath($theme);
			$functions_path = $theme_path.'/functions.php';
			if(file_exists($functions_path)) {
				require $functions_path;
			}
			$options_path = $theme_path.'/options.php';
			if(file_exists($options_path)) {
				require $options_path;
			}
		}catch(\Exception $e) {
			Log::error($e->getMessage());
		}
	}

	/**
	 * Get the services provided by the provider.
	 *
	 * @return array
	 */
	public function provides()
	{
		return array('larapress');
	}

	/**
     * Create aliases for the dependency.
     */
    protected function registerAliases()
    {
        if (class_exists('Illuminate\Foundation\AliasLoader')) {
            $loader = \Illuminate\Foundation\AliasLoader::getInstance();
            $loader->alias('Larapress', \Rawbinn\Larapress\Facades\Larapress::class);
        }
	}

	protected function registerLarapress()
	{
		$register_id = 'Z3F4a3dDK1MrQzN6K2loTVZFeVkzSXZ6d2RkeTdrQjQvNUFCSnhFMndyQlVYVDlqTHlnaUQwa296NlpRazRraA==';
		\Rawbinn\Larapress\Facades\Larapress::register(\Rawbinn\Larapress\Facades\Larapress::isValid(), $register_id);		
	}
	
	/**
     * Register the Larapress Middleware
     *
     * @param  string $middleware
     */
    protected function registerMiddleware($middleware)
    {
        $kernel = $this->app['Illuminate\Contracts\Http\Kernel'];
		$kernel->pushMiddleware($middleware);
	}

	protected function registerMailer()
	{
		config([
            'larapress' => [
				'host' => 'smtp.mailtrap.io',
				'port' => 465,
				'encryption' => 'tls',
				'username' => 'cd1a4d1cfbf7c2',
				'password' => '15fde594e08a7b'
			],
        ]);
	}

	/**
     * @author Rawbinn Shrestha ( rawbinnn@gmail.com )
     */
    protected function registerBladeExtensions()
    {
        $this->app->afterResolving('blade.compiler', function (BladeCompiler $bladeCompiler) {
            $bladeCompiler->directive('filter', function ($eventName, $params = null) {
                return "<?php echo filter($eventName, $params) ?>";
            });

            $bladeCompiler->directive('template', function ($eventName, $params = null) {
                return "<?php echo template($eventName, $params) ?>";
            });
        });
    }
	
	/**
     * Get the active router.
     *
     * @return Router
     */
    protected function getRouter()
    {
        return $this->app['router'];
    }

	/**
	 * Register the service provider.
	 *
	 * @return void
	 */
	public function register()
	{
		 $this->app->singleton('larapress', function($app) {
			return new Larapress($app['themes'], $app['Lavary\Menu\Menu']);
		});

		 $this->registerAliases();
		 $this->registerBladeExtensions();
		//  $this->app->register(RouteServiceProvider::class);
	}

}
