<?php 
namespace Rawbinn\Larapress;

use Rawbinn\Larapress\LarapressResponse;
use Illuminate\Routing\UrlGenerator;

/**
 * Class JavascriptRenderer
 * @package Rawbinn\Larapress
 * @author Rawbinn Shrestha <rawbinnn@gmail.com>
 */
class JavascriptRenderer
{
    /**
     * @var object
     */
    protected $larapress;

    /**
     * @var bool
     */
    protected $enableJqueryNoConflict = true;

    /**
     * JavascriptRenderer constructor.
     * @param \Rawbinn\Larapress\LarapressResponse $larapress
     */
    public function __construct(LarapressResponse  $larapress)
    {
        $this->larapress = $larapress;
    }

    /**
     * @return string
     */
    public function renderHead()
    {
        $cssRoute = route('larapress.assets.css');

        $jsRoute = route('larapress.assets.js');

        $cssRoute = preg_replace('/\Ahttps?:/', '', $cssRoute);
        $jsRoute = preg_replace('/\Ahttps?:/', '', $jsRoute);

        $html = "<link rel='stylesheet' type='text/css' property='stylesheet' href='{$cssRoute}'>";
        $html .= "<script> var editUrl = '".$this->larapress->getUrl()."';</script>";
        $html .= "<script type='text/javascript' src='{$jsRoute}'></script>";

        if ($this->enableJqueryNoConflict) {
            $html .= '<script>var $j = jQuery.noConflict(true);</script>';
        }
        return $html;
    }

    /**
     * Return assets as a string
     *
     * @param string $type 'js' or 'css'
     * @return string
     */
    public function dumpAssetsToString($type)
    {
        // $this->larapress->getUrl();
        $files = $this->getAssets($type);
        $content = '';
        foreach ($files as $file) {
            $content .= file_get_contents($file) . "\n";                
        }
        return $content;
    }

    /**
     * @param $type
     * @return array
     */
    public function getAssets($type)
    {
        $asset = [];
        if($type == 'css'){
            // $assets[] = __DIR__ . '/Resources/assets/font-awesome.min.css';
            $assets[] = __DIR__ . '/Resources/assets/larapress-adminbar.css';
        }
        elseif($type == 'js')
        {
            $assets[] = __DIR__ . '/Resources/assets/jquery.min.js';
            $assets[] = __DIR__ . '/Resources/assets/larapress-adminbar.js';
        }
        return $assets;
    }

}
