<?php

namespace Rawbinn\Larapress;

use Illuminate\Support\Facades\Event;

/**
 * Class EventManager.
 *
 * @version 1.0.0
 *
 * @author Rawbinn Shrestha <contact@rawbinn.com>
 * @organization RAWBINN.COM.
 */
class EventManager
{
    /**
     * Contains all themes.
     *
     * @var array
     */
    protected $templates = [];

    /**
     * Paramters passed with event.
     *
     * @var array
     */
    protected $params;

    /**
     * @var
     */
    protected $query;

    /**
     * Fires event for rendering template.
     *
     * @param $eventName
     * @param null $params
     *
     * @return array
     *
     * @author Rawbinn Shrestha ( rawbinnn@gmail.com )
     */
    public function handleRenderEvent($eventName, $params = null)
    {
        if ($params instanceof \Illuminate\Database\Eloquent\Builder) {
            $this->params = $params;
        } else {
            $this->params = $params ?? [];
        }

        Event::dispatch($eventName, $this);

        return $this->templates;
    }

    public function handleFilter($eventName, $params = null)
    {
        if ($params instanceof \Illuminate\Database\Eloquent\Builder) {
            $this->params = $params;
        } else {
            $this->params = $params ?? [];
        }
        Event::dispatch($eventName, $this);

        return $this->params;
    }

    public function setParams($params)
    {
        $this->params = $params;
    }

    /**
     * @return array
     *
     * @author Rawbinn Shrestha ( rawbinnn@gmail.com )
     */
    public function getParams()
    {
        return $this->params;
    }

    /**
     * @param $name
     *
     * @return mixed
     *
     * @author Rawbinn Shrestha ( rawbinnn@gmail.com )
     */
    public function getParam($name)
    {
        return optional($this->params)[$name];
    }

    /**
     * Add templates for render.
     *
     * @param $template
     *
     * @author Rawbinn Shrestha ( rawbinnn@gmail.com )
     */
    public function addTemplate($template)
    {
        array_push($this->templates, $template);
    }

    /**
     * Renders templates.
     *
     * @return string
     *
     * @author Rawbinn Shrestha ( rawbinnn@gmail.com )
     */
    public function render()
    {
        if ($this->params instanceof \Illuminate\Database\Eloquent\Builder) {
            return $this->params;
        }
        $string = '';
        if (!is_array($this->params)) {
            $this->params = ['params' => $this->params];
        }
        foreach ($this->templates as $template) {
            if (view()->exists($template)) {
                $string .= view($template, $this->params)->render();
            } elseif (is_string($template)) {
                $string .= $template;
            }
        }

        return $string;
    }
}
