<?php namespace Rawbinn\Larapress\Controllers;

use App\Repositories\Backend\CategoryRepository;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Illuminate\Support\Str;

/**
 * Class CustomPostTypeCategoryController
 * @package Rawbinn\Larapress\Controllers
 * @author Rawbinn Shrestha <rawbinnn@gmail.com>
 */
class CustomPostTypeCategoryController extends Controller
{
/**
     * @var CategoryRepository
     */
    protected $category;

    public function __construct(CategoryRepository $category)
    {
        $this->category = $category;
    }

    /**
     * @return \Illuminate\View\View
     */
    public function index()
    {
    }

    /**
     * Returns form view to create category and also it displays all category.
     *
     * @param null
     *
     * @return mixed
     */
    public function create($type)
    {
        $type = Str::slug(strtolower($type));
        $post_types = get_post_types();
        
        if(!isset($post_types[$type])) {
            abort(404);
        }
        $data = $post_types[$type];
        $data['post_type'] = $type;
        $data['categories'] = $this->category->getTree($type); // Returns tree of approved categories
        
        $data['parents'] = $this->category->getCategoriesWithChild($type); // Returns parent categories with limit 10

        return view('admin.custom_post.category.create', $data);
    }

    /**
     * Store category and redirect back to same page.
     *
     * @return mixed
     */
    public function store($type, Request $request)
    {
        $request->validate([
            'title' => 'required',
        ]);

        $type = Str::slug(strtolower($type));

        $data = $request->all();
        $data['display'] = $type;
        $this->category->create($data);

        return redirect()->back()->withFlashSuccess(trans('alerts.backend.general.created', ['attribute' => 'category']));
    }

    /**
     * @param $id
     *
     * @return \Illuminate\Http\JsonResponse
     *
     * @throws \Throwable
     */
    public function edit($type, $id, Request $request)
    {
        $type = Str::slug(strtolower($type));
        $post_types = get_post_types();
        
        if(!isset($post_types[$type])) {
            abort(404);
        }
        $data['lang'] = lang($request->lang);
        $data['post_type'] = $type;

        $data['categories'] = $this->category->getTree($type); // Returns tree of approved categories
        $data['category'] = $this->category->find($id);

        return view('admin.custom_post.category.edit', $data);
    }

    /**
     * @return \Illuminate\Http\JsonResponse
     *
     * @throws \App\Exceptions\GeneralException
     */
    public function update($type, $id, Request $request)
    {
        $locale = $request->lang ?? app()->getLocale();
        $request->validate([
            $locale.'.title' => 'required',
            'slug' => 'required'
        ]);
        
        $type = Str::slug(strtolower($type));
        
        $data['post_type'] = $type;
        $category = $this->category->find($id);
        $this->category->update($category, $request->all());

        return redirect()->back()->withFlashSuccess(trans('alerts.backend.general.updated', ['attribute' => 'category']));
    }

    /**
     * @param int $id
     *
     * @return json
     */
    public function delete($id)
    {
    }

    public function deleteSelected($type, Request $request)
    {
        $this->category->deleteSelected($request->id);
        return response()->json(['status' => true, 'message' => 'Selected categories deleted successfully.']);
    }
}