

<?php $__env->startSection('title', trans('labels.backend.access.roles.management')); ?>

<?php $__env->startSection('after-styles'); ?>
        <!-- DataTables -->
  <?php echo e(style('vendor/datatables-bs4/css/dataTables.bootstrap4.min.css')); ?>

  <?php echo e(style('vendor/datatables-responsive/css/responsive.bootstrap4.min.css')); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('page-header'); ?>
    <h1><?php echo e(trans('labels.backend.access.roles.management')); ?></h1>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="card">
        <div class="card-header with-border">
            <h3 class="card-title"><?php echo e(trans('labels.backend.access.roles.management')); ?></h3>
            <div class="card-tools float-right">
                <?php echo $__env->make('admin.access.includes.partials.role-header-buttons', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            </div>
        </div><!-- /.card-header -->

        <div class="card-body">
            <div class="table-responsive">
                <table id="roles-table" class="table table-condensed table-hover">
                    <thead>
                        <tr>
                            <th><?php echo e(trans('labels.backend.access.roles.table.role')); ?></th>
                            <th><?php echo e(trans('labels.backend.access.roles.table.permissions')); ?></th>
                            <th><?php echo e(trans('labels.backend.access.roles.table.number_of_users')); ?></th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                </table>
            </div><!--table-responsive-->
        </div><!-- /.card-body -->
    </div><!--box-->

    <div class="card">
        <div class="card-header with-border">
            <h3 class="card-title"><?php echo e(trans('history.backend.recent_history')); ?></h3>
            <div class="card-tools float-right">
                <button class="btn btn-box-tool" data-widget="collapse"><i class="fa fa-minus"></i></button>
            </div><!-- /.box tools -->
        </div><!-- /.card-header -->
        <div class="card-body">
            <?php echo history()->renderType('Role'); ?>

        </div><!-- /.card-body -->
    </div><!--card-->
<?php $__env->stopSection(); ?>
<?php $__env->startPush('after-scripts'); ?>
<!-- DataTables -->
    <?php echo e(script('vendor/datatables/jquery.dataTables.min.js')); ?>

    <?php echo e(script('vendor/datatables-bs4/js/dataTables.bootstrap4.min.js')); ?>


    <script>
        $(function() {
            $('#roles-table').DataTable({
                processing: true,
                serverSide: true,
                ajax: {
                    url: '<?php echo e(route("admin.access.role.get")); ?>',
                    type: 'post',
                    data: {_token: Laravel.csrfToken}
                },
                columns: [
                    {data: 'name', name: '<?php echo e(config('access.roles_table')); ?>.name', render: $.fn.dataTable.render.text()},
                    {data: 'permissions', name: '<?php echo e(config('access.permissions_table')); ?>.display_name', sortable: false},
                    {data: 'users', name: 'users', searchable: false, sortable: false},
                    {data: 'actions', name: 'actions', searchable: false, sortable: false}
                ],
                order: [[0, "asc"]],
                searchDelay: 500
            });
        });
    </script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/ritubeau/public_html/resources/views/admin/access/roles/index.blade.php ENDPATH**/ ?>