

<?php $__env->startSection('title',$labels['name'] ?? $label); ?>

<?php $__env->startSection('page-header'); ?>
    <h1>
        <?php echo e($label ?? 'Item'); ?>

        <small>Edit <?php echo e($label); ?></small>
    </h1>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('after-styles'); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <?php echo e(Form::model($page, ['route' => ['admin.custom.post.type.update', $post_type, $page->id], 'role' => 'form', 'method' => 'put'])); ?>

    <input name="lang" type="hidden" value="<?php echo e($lang); ?>">
    <div class="row">
        <div class="col-md-8">
            <ul class="nav nav-tabs nav-fill border-light">
                <?php $__currentLoopData = locales(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $locale): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
  					<li class="nav-item">
  						<a class="nav-link text-reset <?php if($locale == $lang ): ?> active <?php else: ?> bg-soft-dark border-light border-left-0 <?php endif; ?> py-3" href="<?php echo e(route('admin.custom.post.type.edit', [$post_type, $page->id])); ?>?lang=<?php echo e($locale); ?>">
  							<img src="<?php echo e(public_asset('images/flags/'.$locale.'.png')); ?>" height="11" class="mr-1">
  							<span><?php echo e($locale); ?></span>
  						</a>
  					</li>
  		        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </ul>
            <div class="card">
                <div class="card-header with-border">
                    <h3 class="card-title">Edit <?php echo e($labels['name'] ?? $label); ?></h3>
                    <div class="card-tools float-right">
                        <a href="<?php echo e(route('admin.custom.post.type.create',$post_type)); ?>" class="btn btn-success btn-xs float-right"><?php echo e($labels['add_new'] ?? 'Add New Item'); ?></a>
                    </div><!--card-tools float-right-->
                    
                </div><!-- /.card-header -->

                <div class="card-body">
                    <?php if( array_key_exists('title', $supports)): ?>
                    <div class="form-group">
                        <?php echo e(Form::label('title', $supports['title'])); ?>

                        <input type="text" class="form-control" name="<?php echo e($lang); ?>[title]" value="<?php echo e($page->translate($lang)->title ?? $page->title); ?>" placeholder="<?php echo e($supports['title']); ?>">
                    </div>
                    <?php endif; ?>
                    <?php if( array_key_exists('subtitle', $supports)): ?>
                    <div class="form-group">
                        <?php echo e(Form::label('subtitle', $supports['subtitle'])); ?>

                        <textarea name="<?php echo e($lang); ?>[subsubtitle]" class="form-control seshra-text-editor" data-airmode="true" placeholder="<?php echo e($supports['subtitle']); ?>"><?php echo $page->translate($lang)->subtitle ?? $page->subtitle; ?></textarea>
                        
                    </div>
                    <?php endif; ?>
                    <?php if( array_key_exists('title', $supports)): ?>
                    <div class="form-group">
                        <?php echo e(Form::label('slug', trans('validation.attributes.backend.page.slug'))); ?>

                        <?php echo e(Form::text('slug', null, ['class' => 'form-control','placeholder' => trans('validation.attributes.backend.page.slug')])); ?>

                    </div>
                    <?php endif; ?>
                    <?php if( array_key_exists('editor', $supports)): ?>
                    <div class="form-group">
                        <label for="content"><?php echo e($supports['editor']); ?></label>
                        <textarea name="<?php echo e($lang); ?>[content]" class="seshra-text-editor" data-min-height="300" data-image-submit-url="<?php echo e(route('admin.image.upload')); ?>" data-format="true" data-image-group="blogs"><?php echo $page->translate($lang)->content ?? $page->content; ?></textarea>
                    </div>
                    <?php endif; ?>
                    <div class="form-group">
                        <label for="meta-title" class="meta-title">Meta Title <small>(Recommended less than 60 characters) <span id="meta_title_length" class="<?php echo e(strlen($page->meta_title) < 61 ? 'green' : 'red'); ?>"><?php echo e(strlen($page->meta_title)); ?> characters</span></small></label>
                        <?php echo e(Form::text('meta_title', null, ['class' => 'form-control','placeholder' => 'Meta Title','id' => 'meta-title'])); ?>

                    </div>
                    <div class="form-group">
                        <label for="meta-description" class="meta-description">Meta Description <small>(Recommended less than 160 characters) <span  id="meta_description_length" class="<?php echo e(strlen($page->meta_description) < 161 ? 'green' : 'red'); ?>"><?php echo e(strlen($page->meta_description)); ?> characters</span></small></label>
                        <?php echo e(Form::textarea('meta_description', null, ['class' => 'form-control','rows' => '4','id' => 'meta-description'])); ?>

                    </div>
                </div>
            </div>
            
        </div>
        <div class="col-md-4">
            <?php if( array_key_exists('category', $supports)): ?>
            <div class="card">
                <div class="card-header with-border">
                    <h3 class="card-title"><?php echo e($supports['category']); ?></h3>
                </div><!-- /.card-header -->
                <div class="card-body">
                    <div class="form-group">
                        <div id="selectCategory">
                            <ul>
                                <?php echo $__env->make('admin.custom_post.categories',['categories' => $categories], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                            </ul>
                        </div>
                    </div>
                </div>
                <!--form control-->
            </div>
            <?php endif; ?>
            <?php if( array_key_exists('thumbnail', $supports)): ?>
            <div class="card">
                <div class="card-header with-border">
                    <h3 class="card-title"><?php echo e($supports['thumbnail']); ?></h3>
                </div><!-- /.card-header -->
                <div class="card-body">
                    <div class="form-group">
                        <div class="input-group" data-toggle="seshra-uploader" data-type="image" data-group="blogs">
                            <div class="input-group-prepend">
                                <div class="input-group-text bg-soft-secondary font-weight-medium">Browse</div>
                            </div>
                            <div class="form-control file-amount">Choose File</div>
                            <input type="hidden" name="featured_image" value="<?php echo e($page->media_id); ?>" class="selected-files">
                        </div>
                        <div class="file-preview box sm">
                        </div>
                    </div>
                </div><!-- /.card-body -->
            </div>
            <?php endif; ?>
            <div class="card position-sticky" style="top: 30px">
                <div class="card-body">
                    <div class="form-group">
                        <?php echo e(Form::submit(trans('buttons.general.crud.update'), ['class' => 'btn btn-success btn-md'])); ?>

                    </div>
                </div>
                <!--form control-->
            </div>
            <!--card-->
        </div>
    </div>
    <?php echo e(Form::close()); ?>



<?php $__env->stopSection(); ?>
<?php $__env->startPush('after-scripts'); ?>
    <script>
        $(function() {
            var type;
          

            $(document).on('click', '#saveEdit', function(e) {
                $("<input>").attr({
                    name: "saveEdit",
                    id: "savenedit",
                    type: "hidden",
                    value: 'saveEdit'
                }).appendTo("#postForm");

                $('#postForm').submit();
            });

            $('#meta-title').on('keyup', function() {
                var length = $(this).val().length;
                if (length > 60) {
                    $('#meta_title_length').addClass('red');
                    $('#meta_title_length').removeClass('green');
                } else {
                    $('#meta_title_length').removeClass('red');
                    $('#meta_title_length').addClass('green');
                }
                $('#meta_title_length').html(length + ' characters');
            });

            $('#meta-description').on('keyup', function() {
                var length = $(this).val().length;
                if (length > 160) {
                    $('#meta_description_length').addClass('red');
                    $('#meta_description_length').removeClass('green');
                } else {
                    $('#meta_description_length').removeClass('red')
                    $('#meta_description_length').addClass('green');;
                }
                $('#meta_description_length').html(length + ' characters');
            });
        });
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/ritubeau/public_html/resources/views/admin/custom_post/edit.blade.php ENDPATH**/ ?>