<html>
  <head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <title>Log in | <?php echo e(setting('site-title', 'Larapress')); ?></title>
    <!-- Tell the browser to be responsive to screen width -->
    <meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">
    <link rel="apple-touch-icon" sizes="57x57" href="<?php echo e(public_asset('images/favicon/apple-icon-57x57.png')); ?>">
      <link rel="apple-touch-icon" sizes="60x60" href="<?php echo e(public_asset('images/favicon/apple-icon-60x60.png')); ?>">
      <link rel="apple-touch-icon" sizes="72x72" href="<?php echo e(public_asset('images/favicon/apple-icon-72x72.png')); ?>">
      <link rel="apple-touch-icon" sizes="76x76" href="<?php echo e(public_asset('images/favicon/apple-icon-76x76.png')); ?>">
      <link rel="apple-touch-icon" sizes="114x114" href="<?php echo e(public_asset('images/favicon/apple-icon-114x114.png')); ?>">
      <link rel="apple-touch-icon" sizes="120x120" href="<?php echo e(public_asset('images/favicon/apple-icon-120x120.png')); ?>">
      <link rel="apple-touch-icon" sizes="144x144" href="<?php echo e(public_asset('images/favicon/apple-icon-144x144.png')); ?>">
      <link rel="apple-touch-icon" sizes="152x152" href="<?php echo e(public_asset('images/favicon/apple-icon-152x152.png')); ?>">
      <link rel="apple-touch-icon" sizes="180x180" href="<?php echo e(public_asset('images/favicon/apple-icon-180x180.png')); ?>">
      <link rel="icon" type="image/png" sizes="192x192"  href="<?php echo e(public_asset('images/favicon/android-icon-192x192.png')); ?>">
      <link rel="icon" type="image/png" sizes="32x32" href="<?php echo e(public_asset('images/favicon/favicon-32x32.png')); ?>">
      <link rel="icon" type="image/png" sizes="96x96" href="<?php echo e(public_asset('images/favicon/favicon-96x96.png')); ?>">
      <link rel="icon" type="image/png" sizes="16x16" href="<?php echo e(public_asset('images/favicon/favicon-16x16.png')); ?>">
      <link rel="manifest" href="<?php echo e(public_asset('images/favicon/manifest.json')); ?>">
      <meta name="msapplication-TileColor" content="#ffffff">
      <meta name="msapplication-TileImage" content="<?php echo e(public_asset('images/favicon/ms-icon-144x144.png')); ?>">
      <meta name="theme-color" content="#ffffff">
      <!-- Bootstrap 3.3.7 -->
      <?php echo e(style('vendor/admin-lte/dist/css/adminlte.min.css')); ?>

      <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.14.0/css/all.min.css" integrity="sha512-1PKOgIY59xJ8Co8+NE6FZ+LOAZKjy+KY8iq0G4B3CyeY6wYHN3yt9PW0XpSriVlkMXe40PTKnXrLnZ9+fkDaog==" crossorigin="anonymous" />

      <link rel="stylesheet" type="text/css" href="https://cdnjs.cloudflare.com/ajax/libs/iCheck/1.0.2/skins/square/blue.css">
      <!-- HTML5 Shim and Respond.js IE8 support of HTML5 elements and media queries -->
      <!-- WARNING: Respond.js doesn't work if you view the page via file:// -->
      <!--[if lt IE 9]>
      <script src="https://oss.maxcdn.com/html5shiv/3.7.3/html5shiv.min.js"></script>
      <script src="https://oss.maxcdn.com/respond/1.4.2/respond.min.js"></script>
      <![endif]-->

      <!-- Google Font -->
      <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,600,700,300italic,400italic,600italic">
</head>
<body class="hold-transition login-page" style="">

<div class="login-box">
  
  <div class="login-logo mb-4">
    <a href="<?php echo e(route('index')); ?>"><img src="<?php echo e(setting('site-logo-dark') ? site_logo('dark') : site_logo()); ?>" style="max-width: 200px;"></a>
  </div>
  <!-- /.login-logo -->
  <?php echo $__env->make('includes.partials.messages', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
  <div class="card">
    <div class="card-body login-card-body">
      <p class="login-box-msg">Sign in to start your session</p>

      <form action="<?php echo e(route('auth.login')); ?>" method="post">
        <?php echo csrf_field(); ?>
        <div class="input-group mb-3">
          <input type="email" name="email" class="form-control" placeholder="Email">
          <div class="input-group-append">
            <div class="input-group-text">
              <span class="fas fa-envelope"></span>
            </div>
          </div>
        </div>
        <div class="input-group mb-3">
          <input type="password" name="password" class="form-control" placeholder="Password">
          <div class="input-group-append">
            <div class="input-group-text">
              <span class="fas fa-lock"></span>
            </div>
          </div>
        </div>
        <div class="row">
          <div class="col-8">
            <div class="icheck-primary">
              <input type="checkbox" name="remember" id="remember">
              <label for="remember">
                Remember Me
              </label>
            </div>
          </div>
          <!-- /.col -->
          <div class="col-4">
            <button type="submit" class="btn btn-primary btn-block">Sign In</button>
          </div>
          <!-- /.col -->
        </div>
      </form>

      <p class="mb-1">
        <a href="<?php echo e(route('auth.password.reset')); ?>">I forgot my password</a>
      </p>
    </div>
    <!-- /.login-card-body -->
  </div>
</div>

<!-- jQuery 3 -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.2.1/jquery.min.js"></script>
<!-- Bootstrap 3.3.7 -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/twitter-bootstrap/3.3.7/js/bootstrap.min.js"></script>
<!-- iCheck -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/iCheck/1.0.2/icheck.min.js"></script>
<script>
  $(function () {
    $('input').iCheck({
      checkboxClass: 'icheckbox_square-blue',
      radioClass: 'iradio_square-blue',
      increaseArea: '20%' // optional
    });
  });
</script>


<script type="text/javascript">( function(){ window.SIG_EXT = {}; } )()</script></body></html><?php /**PATH D:\laragon\www\arkbotech.com\resources\views/admin/auth/login.blade.php ENDPATH**/ ?>