<!DOCTYPE html>
<html lang="<?php echo e(app()->getLocale()); ?>">
<head>
	<meta charset="utf-8">
	<meta http-equiv="X-UA-Compatible" content="IE=edge">
	<meta name="viewport" content="width=device-width, initial-scale=1, user-scalable=0,  target-densitydpi=device-dpi">
	<meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
	<meta http-equiv="content-language" content="<?php echo e(app()->getLocale()); ?>">

    <?php echo SEO::generate(); ?>

    
	<link rel="icon" href="<?php echo e(site_favicon()); ?>">
	<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.1.1/css/all.min.css">
	<link rel="preconnect" href="https://fonts.googleapis.com">
	<link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
	<link href="https://fonts.googleapis.com/css2?family=Lato:wght@300;400;700;900&display=swap" rel="stylesheet">
	<link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700;800;900&display=swap" rel="stylesheet">
	<link href="<?php echo e(Theme::asset('css/bootstrap.min.css')); ?>" rel="stylesheet">
	<link href="<?php echo e(Theme::asset('css/style.css')); ?>" rel="stylesheet">
    <script defer src="https://use.fontawesome.com/releases/v5.0.6/js/all.js"></script>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.8.3/font/bootstrap-icons.css">
	<?php echo $__env->yieldPushContent('styles'); ?>
	<style>
		.modal{
			z-index: 99999;
		}
        <?php echo e(custom_css()); ?>

    </style>
</head>

<body>
	<div class="container-fluid main-wrapper">
		
		<?php echo $__env->make('ctremit::header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
		
		
		<?php echo $__env->yieldContent('content'); ?>

		
		<?php echo $__env->make('ctremit::footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
	</div>
    
	<script src="https://ajax.googleapis.com/ajax/libs/jquery/1.12.4/jquery.min.js"></script>
    <script type="text/javascript" src="<?php echo e(Theme::asset('js/bootstrap.min.js')); ?>"></script>
	<script>
		$('#change_language').on('change', function(e){
			e.preventDefault();
			var locale = $(this).val();
			var _token ="<?php echo e(csrf_token()); ?>";
			$.post('<?php echo e(route('language.change')); ?>',{_token:_token, locale:locale}, function(data){
				location.reload();
			});

		});
	</script>
 	<script src="https://www.google.com/recaptcha/api.js" async defer></script>
	 <?php echo $__env->yieldPushContent('scripts'); ?>
</body>
</html>
<?php /**PATH /home3/shrestha/ctremit.seshra.com.np/public/themes/ctremit/views/layouts/master.blade.php ENDPATH**/ ?>