

<?php $__env->startSection('title', trans('labels.backend.blog.edit')); ?>

<?php $__env->startSection('page-header'); ?>
    <h1>
        <?php echo e(trans('labels.backend.blog.management')); ?>

        <small><?php echo e(trans('labels.backend.blog.edit')); ?></small>
    </h1>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('after-styles'); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="admin-post">
    <?php echo e(Form::model($post,['route' => ['admin.blog.update', $post->id], 'role' => 'form', 'method' => 'put'])); ?>

    <input name="lang" type="hidden" value="<?php echo e($lang); ?>">
    <div class="row">
    <div class="col-md-8">
        <ul class="nav nav-tabs nav-fill border-light">
            <?php $__currentLoopData = locales(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $locale): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                  <li class="nav-item">
                      <a class="nav-link text-reset <?php if($locale == $lang ): ?> active <?php else: ?> bg-soft-dark border-light border-left-0 <?php endif; ?> py-3" href="<?php echo e(route('admin.blog.edit', $post->id)); ?>?lang=<?php echo e($locale); ?>">
                          <img src="<?php echo e(public_asset('images/flags/'.$locale.'.png')); ?>" height="11" class="mr-1">
                          <span><?php echo e($locale); ?></span>
                      </a>
                  </li>
              <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </ul>
        <div class="card">
            <div class="card-header with-border">
                <h3 class="card-title"><?php echo e(trans('labels.backend.blog.edit')); ?></h3>

                <div class="card-tools float-right">
                    <?php echo e(link_to_route('admin.blog.create', trans('menus.backend.blog.create'), [], ['class' => 'btn btn-success btn-xs'])); ?>

                </div>
            </div><!-- /.card-header -->

            <div class="card-body">
                <div class="form-group">
                    <?php echo e(Form::label('title', trans('validation.attributes.backend.blog.title'))); ?>

                    <input type="text" class="form-control" name="<?php echo e($lang); ?>[title]" value="<?php echo e($post->translate($lang)->title ?? $post->title); ?>" placeholder="<?php echo e(trans('validation.attributes.backend.blog.title')); ?>">
                </div><!--form control-->

                <div class="form-group">
                    <?php echo e(Form::label('slug', trans('validation.attributes.backend.blog.slug'))); ?>

                    <?php echo e(Form::text('slug', null, ['class' => 'form-control', 'placeholder' => trans('validation.attributes.backend.blog.slug')])); ?>

                </div><!--form control-->

                <div class="form-group">
                    <label for="content">Content</label>
                    <textarea class="seshra-text-editor" name="<?php echo e($lang); ?>[content]" data-min-height="300" data-image-submit-url="<?php echo e(route('admin.image.upload')); ?>" data-format="true" data-image-group="blogs"><?php echo $post->translate($lang)->content ?? ''; ?></textarea>
                </div>

                <?php echo template('larapress.blog.input', ) ?>

            </div>
        </div>
        <?php echo template('larapress.blog.card', ) ?>
        <div class="card">
            <div class="card-header with-border">
                <h3 class="card-title">Seo Information</h3>
            </div><!-- /.card-header -->

            <div class="card-body">
                 <div class="form-group">
                    <label for="meta-title" class="meta-title" >Meta Title <small>(Recommended less than 60 characters) <span id="meta_title_length" class="<?php echo e(strlen($post->meta_title)< 61 ? 'green': 'red'); ?>"><?php echo e(strlen($post->meta_title)); ?> characters</span></small></label>
                    <?php echo e(Form::text('meta_title', null, ['class' => 'form-control', 'placeholder' =>'Meta Title', 'id' =>  'meta-title'])); ?>

                </div><!--form group-->

                <div class="form-group">
                    <label for="meta-description" class="meta-description">Meta Description <small>(Recommended less than 160 characters) <span id="meta_description_length" class="<?php echo e(strlen($post->meta_description)< 161 ? 'green': 'red'); ?>"><?php echo e(strlen($post->meta_description)); ?> characters</span></small></label>
                    <?php echo e(Form::textarea('meta_description', null, ['class' => 'form-control', 'rows' => '4', 'id' => 'meta-description'])); ?>

                </div>
            </div><!-- /.card-body -->
        </div>
        </div>
        <div class="col-md-4">
            <?php echo template('larapress.blog.sidebar.before', ) ?>

            <div class="card">
                <div class="card-body">
                    <div class="form-group">
                        <?php echo e(Form::label('status', 'Status')); ?>

                        <select name="status" class="form-control">
                            <option value="1" <?php echo e($post->status == '1' ? 'selected' : ''); ?>>Published</option>
                            <option value="0" <?php echo e($post->status == '0' ? 'selected' : ''); ?>>Draft</option>
                        </select>
                    </div>
                    <div class="form-group">
                        <?php echo e(Form::label('data', 'Publish Date')); ?>

                        <input type="text" class="form-control seshra-date-range" name="date" value="<?php echo e($post->created_at); ?>" data-single="true" data-time-picker="true" data-format="YYYY-MM-DD HH:mm:ss">
                    </div>
                </div><!--form control-->
            </div><!--card-->

            <div class="card">
                <div class="card-header with-border">
                    <h3 class="card-title"><?php echo e(trans('validation.attributes.backend.category.categories')); ?></h3>
                </div><!-- /.card-header -->
                <div class="card-body">
                    <div class="form-group">
                        <?php echo e(Form::hidden('category_id',$post->category_id,['id' => 'category_id'])); ?>

                        <div id="selectCategory">
                            <ul>
                                <?php echo $__env->make('admin.blogs.categories',['categories' => $categories], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                            </ul>
                        </div>
                    </div>
                    <div class="form-group">
                        <?php echo e(Form::label('parent', trans('validation.attributes.backend.tag.tags'))); ?>

                        <input type="text" class="form-control seshra-tag-input" id="tags" name="tags" data-on-change="load_tags" data-keydown="true" data-whitelist ="" value="<?php echo e(($post->tags) ? implode(',', $post->tags()->pluck('title')->toArray()) : ''); ?>" placeholder="Type and hit enter to add a tag">
                    </div>
                </div><!--form control-->
            </div><!--card-->
            
            <div class="card">
                <div class="card-header with-border">
                    <h3 class="card-title">Featured</h3>
                </div><!-- /.card-header -->

                <div class="card-body">
                    <div class="form-group">
                        <div class="input-group" data-toggle="seshra-uploader" data-type="image" data-group="blogs">
                            <div class="input-group-prepend">
                                <div class="input-group-text bg-soft-secondary font-weight-medium">Browse</div>
                            </div>
                            <div class="form-control file-amount">Choose Image</div>
                            <input type="hidden" name="media_id" class="selected-files" value="<?php echo e($post->media_id); ?>">
                        </div>
                        <div class="file-preview box sm">
                        </div>
                    </div>
                </div><!-- /.card-body -->
            </div><!--card-->

            <?php echo template('larapress.blog.sidebar.after', ['post' => $post], ) ?>

            <div class="card position-sticky" style="top: 30px">
                <div class="card-body">
                    <div class="form-group">
                        <?php echo e(Form::submit(trans('buttons.general.crud.update'), ['class' => 'btn btn-success btn-md'])); ?>

                    </div>
                </div><!--form control-->
            </div><!--card-->
        </div>
    </div>
    <?php echo e(Form::close()); ?>

</div>
<?php $__env->stopSection(); ?>
<?php $__env->startPush('before-scripts'); ?>
<script>
    var tagsearchurl = base_url + '/admin/api/tag/search';
    var timeout;
    function load_tags(e, taggy) {
        var tagify = $('#tags').data('tagify');
        if(e.type == 'input' && taggy.value.length > 2) {
            tagify.settings.whitelist.length = 0;
            if (taggy === undefined) return;
            tagify.loading(true);
            if (timeout) {
                clearTimeout(timeout);
            }
            timeout = setTimeout(function() {
                $.ajax({
                    type: "POST",
                    url: tagsearchurl,
                    data: { q: taggy.value },
                    success: function(data) {
                        tagify.loading(false);
                        if (data.status !== false) {
                            tagify.settings.whitelist.push(...data.data, taggy.value);
                            tagify.dropdown.show.call(tagify);
                        }
                    },
                    error: function() {
                        tagify.loading(false);
                        tagify.dropdown.hide.call(tagify, taggy.value);
                        alert('Error!!! Contact Administrator')
                    }
                });
            }, 700);
        }
    }
</script>
<?php $__env->stopPush(); ?>
<?php $__env->startPush('after-scripts'); ?>
<script>
    
    $(function () {
        $('#meta-title').on('keyup', function() {
            var length = $(this).val().length;
            if(length > 60) {
                $('#meta_title_length').addClass('red');
                $('#meta_title_length').removeClass('green');
            }
            else{
                $('#meta_title_length').removeClass('red');
                $('#meta_title_length').addClass('green');
            }
            $('#meta_title_length').html(+length+ ' characters');
        });
        $('#meta-description').on('keyup', function() {
            var length = $(this).val().length;
            if(length > 160) {
                $('#meta_description_length').addClass('red');
                $('#meta_description_length').removeClass('green');
            }
            else{
                $('#meta_description_length').removeClass('red')
                $('#meta_title_length').addClass('green');;
            }
            $('#meta_description_length').html(+length+ ' characters');
        });
    });
</script>
    
<?php $__env->stopPush(); ?>

<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\arkbo\resources\views/admin/blogs/edit.blade.php ENDPATH**/ ?>