<div class="card" id="<?php echo e($name); ?><?php echo e($col); ?><?php echo e($item); ?>">
    <div class="card-header with-border">
        <h3 class="card-title">Text Block [Title, Content, Image]</h3>
        <div class="card-tools float-right">
            <?php if(isset($page)): ?>
                <button type="button" class="btn btn-xs btn-danger delete-meta-item" data-pid="<?php echo e($page->id); ?>" data-col="<?php echo e($col); ?>" data-item="<?php echo e($item); ?>" data-key="<?php echo e(Str::slug(strtolower($name))); ?>"><i class="fa fa-trash"></i></button>
            <?php else: ?>
                <button type="button" class="btn btn-xs btn-danger delete-meta-item" data-col="<?php echo e($col); ?>" data-item="<?php echo e($item); ?>" data-key="<?php echo e(Str::slug(strtolower($name))); ?>"><i class="fa fa-trash"></i></button>
            <?php endif; ?>
        </div>
    </div>
    <div class="card-body">
        <input type="hidden" name="post_meta[<?php echo e(Str::slug(strtolower($name))); ?>][<?php echo e($col); ?>][<?php echo e($item); ?>][type]" value="text_block_title_image">
        <div class="form-group">
            <?php echo e(Form::label('title', trans('validation.attributes.backend.page.title'))); ?>

            <input type="text" name="post_meta[<?php echo e(Str::slug(strtolower($name))); ?>][<?php echo e($col); ?>][<?php echo e($item); ?>][title]" class="form-control" value="<?php echo e($post['title'] ?? ''); ?>">
        </div>
        <div class="form-group">
            <label for="content">Content</label>
            <textarea class="seshra-text-editor" name="post_meta[<?php echo e(Str::slug(strtolower($name))); ?>][<?php echo e($col); ?>][<?php echo e($item); ?>][content]" data-min-height="300" data-image-submit-url="<?php echo e(route('admin.image.upload')); ?>" data-format="true" data-image-group="blogs"><?php echo $post['content'] ?? ''; ?></textarea>
        </div>
        <div class="form-group">
            <label for="content">Image</label>
            <div class="input-group" data-toggle="seshra-uploader" data-type="image" data-group="blogs">
                <div class="input-group-prepend">
                        <div class="input-group-text bg-soft-secondary font-weight-medium">Browse</div>
                </div>
                <div class="form-control file-amount">Choose File</div>
                <input type="hidden" name="post_meta[<?php echo e(Str::slug(strtolower($name))); ?>][<?php echo e($col); ?>][<?php echo e($item); ?>][featured_image]" class="selected-files" value="<?php echo e($post['featured_image'] ?? ''); ?>">
            </div>
            <div class="file-preview box sm">
            </div>
        </div>
    </div>
</div>
<?php /**PATH C:\laragon\www\arkbo\resources\views/admin/dynamic_block/text_block_title_image.blade.php ENDPATH**/ ?>