

<?php $__env->startSection('title', trans('labels.backend.blog.create')); ?>

<?php $__env->startSection('page-header'); ?>
    <h1><?php echo e(trans('labels.backend.blog.management')); ?>

        <small><?php echo e(trans('labels.backend.blog.create')); ?></small>
    </h1>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('after-styles'); ?>
<link rel="stylesheet" href="<?php echo e(public_asset('css/timepicker.min.css')); ?>">
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="admin-post">
    <?php echo e(Form::open(['route' => 'admin.blog.store', 'role' => 'form', 'method' => 'post', 'id' => 'postForm'])); ?>

    <div class="row">
        <div class="col-md-8 col-lg-9">
            <div class="card">
                <div class="card-header with-border">
                    <h3 class="card-title"><?php echo e(trans('labels.backend.blog.create')); ?></h3>
                </div>

                <div class="card-body">
                    <div class="form-group">
                        <?php echo e(Form::label('title', trans('validation.attributes.backend.blog.title'))); ?>

                        <?php echo e(Form::text('title', null, ['class' => 'form-control','placeholder' => trans('validation.attributes.backend.blog.title')])); ?>

                    </div>
                    
                    <div class="form-group">
                        <label for="content">Content</label>
                        <textarea class="seshra-text-editor" name="content" data-min-height="300"
                            data-image-submit-url="<?php echo e(route('admin.image.upload')); ?>" data-format="true"
                            data-image-group="blogs"><?php echo old('content'); ?></textarea>
                    </div>

                    <?php echo template('larapress.blog.input', ) ?>
                </div>
            </div>
            <?php echo template('larapress.blog.card', ) ?>
            <div class="card">
                <div class="card-header with-border">
                    <h3 class="card-title">Seo Information</h3>
                </div>

                <div class="card-body">
                    <div class="form-group">
                        <label for="meta-title" class="meta-title">Meta Title <small>(Recommended less than 60 characters) <span id="meta_title_length"></span></small></label>
                        <?php echo e(Form::text('meta_title', null, ['class' => 'form-control','placeholder' => 'Meta Title','id' => 'meta-title'])); ?>

                    </div>

                    <div class="form-group">
                        <label for="meta-description" class="meta-description">Meta Description <small>(Recommended less than 160 characters) <span id="meta_description_length"></span></small></label>
                        <?php echo e(Form::textarea('meta_description', null, ['class' => 'form-control','rows' => '4','id' => 'meta-description'])); ?>

                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-4 col-lg-3">
            <?php echo template('larapress.blog.sidebar.before', ) ?>
            <div class="card">
                <div class="card-body">
                    <div class="form-group">
                        <?php echo e(Form::label('status', 'Status')); ?>

                        <select name="status" class="form-control">
                            <option value="1">Published</option>
                            <option value="0">Draft</option>
                        </select>
                    </div>
                    <div class="form-group">
                        <?php echo e(Form::label('data', 'Publish Date')); ?>

                        <input type="text" class="form-control seshra-date-range" name="date" value="<?php echo e(old('date') ?? date('Y-m-d H:i:s')); ?>" data-single="true" data-time-picker="true" data-format="YYYY-MM-DD HH:mm:ss">
                    </div>
                </div>
            </div>
            <div class="card">
                <div class="card-header with-border">
                    <h3 class="card-title"><?php echo e(trans('validation.attributes.backend.category.categories')); ?></h3>
                </div>
                <div class="card-body">
                    <div class="form-group">
                        <div id="selectCategory">
                            <ul>
                                <?php echo $__env->make('admin.blogs.categories',['categories' => $categories], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                            </ul>
                        </div>
                    </div>
                    <div class="form-group">
                        <?php echo e(Form::label('parent', trans('validation.attributes.backend.tag.tags'))); ?>

                        <input type="text" class="form-control seshra-tag-input" id="tags" name="tags" data-on-change="load_tags" data-keydown="true" data-whitelist ="" placeholder="Type and hit enter to add a tag">
                    </div>
                </div>
            </div>
            <div class="card">
                <div class="card-header with-border">
                    <h3 class="card-title">Featured Image</h3>
                </div>

                <div class="card-body">
                    <div class="form-group">
                        <div class="input-group" data-toggle="seshra-uploader" data-type="image" data-group="blogs">
                            <div class="input-group-prepend">
                                <div class="input-group-text bg-soft-secondary font-weight-medium">Browse</div>
                            </div>
                            <div class="form-control file-amount">Choose File</div>
                            <input type="hidden" name="media_id" class="selected-files">
                        </div>
                        <div class="file-preview box sm">
                        </div>
                    </div>
                    <!--form group-->
                </div><!-- /.card-body -->
            </div>
            <?php echo template('larapress.blog.sidebar.after', ) ?>
            <div class="card position-sticky" style="top: 30px">
                <div class="card-body">
                    <div class="form-group">
                        <input type="submit" name="save" value="Save" class="btn btn-success btn-md">
                        <button type="button" name="saveEdit" id="saveEdit" value="Save & Edit"
                            class="btn btn-success btn-md">Save & Edit</button>
                    </div>
                </div>
                <!--form control-->
            </div>
            

        </div>
    </div>
    <?php echo e(Form::close()); ?>

</div>
<?php $__env->stopSection(); ?>
<?php $__env->startPush('before-scripts'); ?>
<script>
    var tagsearchurl = base_url + '/admin/api/tag/search';
    var timeout;
    function load_tags(e, taggy) {
        var tagify = $('#tags').data('tagify');
        if(e.type == 'input' && taggy.value.length > 2) {
            tagify.settings.whitelist.length = 0;
            if (taggy === undefined) return;
            tagify.loading(true);
            if (timeout) {
                clearTimeout(timeout);
            }
            timeout = setTimeout(function() {
                $.ajax({
                    type: "POST",
                    url: tagsearchurl,
                    data: { q: taggy.value },
                    success: function(data) {
                        tagify.loading(false);
                        if (data.status !== false) {
                            tagify.settings.whitelist.push(...data.data, taggy.value);
                            tagify.dropdown.show.call(tagify);
                        }
                    },
                    error: function() {
                        tagify.loading(false);
                        tagify.dropdown.hide.call(tagify, taggy.value);
                        alert('Error!!! Contact Administrator')
                    }
                });
            }, 700);
        }
    }
</script>
<?php $__env->stopPush(); ?>
<?php $__env->startPush('before-scripts'); ?>
<script src="<?php echo e(public_asset('js/timepicker.min.js')); ?>"></script>
<?php $__env->stopPush(); ?>
<?php $__env->startPush('after-scripts'); ?>
    <script>
        $(function() {

            $(document).on('click', '#saveEdit', function(e) {
                $("<input>").attr({
                    name: "saveEdit",
                    id: "savenedit",
                    type: "hidden",
                    value: 'saveEdit'
                }).appendTo("#postForm");

                $('#postForm').submit();
            });

        });

        $('#meta-title').on('keyup', function() {
            var length = $(this).val().length;
            if (length > 60) {
                $('#meta_title_length').addClass('red');
                $('#meta_title_length').removeClass('green');
            } else {
                $('#meta_title_length').removeClass('red');
                $('#meta_title_length').addClass('green');
            }
            $('#meta_title_length').html(length + ' characters');
        });
        $('#meta-description').on('keyup', function() {
            var length = $(this).val().length;
            if (length > 160) {
                $('#meta_description_length').addClass('red');
                $('#meta_description_length').removeClass('green');
            } else {
                $('#meta_description_length').removeClass('red')
                $('#meta_description_length').addClass('green');;
            }
            $('#meta_description_length').html(length + ' characters');
        });
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\arkbo\resources\views/admin/blogs/create.blade.php ENDPATH**/ ?>