<?php echo e(Form::model($menu_item, ['id' => 'menuEditForm', 'class' => 'full-width'])); ?>

    <div class="card">
        <div class="card-header with-border">
            <h3 class="card-title">Edit Menu</h3>

            <div class="card-tools float-right">
                <!-- Include your header buttons -->
            </div><!--card-tools float-right-->
        </div><!-- /.card-header -->
    
        <div class="card-body">
            <div class="alert alert-success alert-dismissable" style="display: none">
                
            </div>
            <?php $__currentLoopData = locales(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $locale): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="form-group">
                <?php echo e(Form::label('title', trans('validation.attributes.backend.menu.title'). '('.$locale.')')); ?>

                <input type="text" name="<?php echo e($locale); ?>[title]" class="form-control" value="<?php echo e($menu_item->translate($locale)->title); ?>" placeholder="<?php echo e(trans('validation.attributes.backend.menu.title')); ?>" required>
            </div><!--form group-->
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            <div class="form-group">
                <?php echo e(Form::label('url', trans('validation.attributes.backend.menu.url'))); ?>

                <?php echo e(Form::text('url', null, ['class' => 'form-control', 'placeholder' => trans('validation.attributes.backend.menu.url')])); ?>

            </div><!--form group-->
            <div class="form-group">
                <?php echo e(Form::label('icon', trans('validation.attributes.backend.menu.icon'))); ?>

                <?php echo e(Form::text('icon', null, ['class' => 'form-control', 'placeholder' => trans('validation.attributes.backend.menu.icon')])); ?>

            </div><!--form group-->
             <div class="form-group">
                <?php echo e(Form::label('parent', trans('validation.attributes.backend.menu.parent'))); ?>

                <?php echo e(Form::hidden('parent_id', $menu_item->parent_id ,['id' => 'parent_id_edit'])); ?>

                <div class="btn-group dropdown" id="parentEditMenu">
                  <button type="button" class="btn btn-default btn-sm dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                    <span id="menuEditSelected"><?php echo e(($menu_item->parent!=null) ? $menu_item->parent->title : 'Choose Parent'); ?></span> <span class="caret"></span>
                  </button>
                  <ul class="dropdown-menu">
                     <li><a class="dropdown-item" href="0" data-title="None" id="parentLink">None</a></li>
                     <div id="selectMenuList">
                        <?php echo $__env->make('admin.menus.selectMenuList',['menus' => $menus], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    </div>
                  </ul>
                </div>
            </div><!--form group-->
            <?php echo e(Form::hidden('menu_id', $menu_item->id)); ?>

        </div><!-- /.card-body -->
    <div class="card-footer">
        <div class="float-right">
            <?php echo e(Form::submit('Update', ['class' => 'btn btn-default btn-sm'])); ?>

        </div><!--float-right-->
    </div>
    </div><!--box-->

<?php echo e(Form::close()); ?>


<script type="text/javascript">
   // Select Menu Option for Edit /////////////////////////////////////////////////
   $('#parentEditMenu').on('click','#parentLink',function(event) {
        event.preventDefault();
        var id = $(this).attr('href');
        var title = $(this).data('title');
        $('#parent_id_edit').val(id);
        $('#menuEditSelected').html(title);
    });
   // End /////////////////////////////////////////////////////////////////////////
</script>
    <?php /**PATH C:\laragon\www\arkbo\resources\views/admin/menus/edit.blade.php ENDPATH**/ ?>