

<?php $__env->startSection('title', 'Contact Form | Edit Contact Form'); ?>

<?php $__env->startSection('page-header'); ?>
    <h1>
        Contact Form
        <small>Edit Contact Form</small>
    </h1>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <?php echo e(Form::model($contact, ['route' => ['admin.contact.update', $contact->id], 'role' => 'form', 'method' => 'put'])); ?>


        <div class="card">
            <div class="card-header with-border">
                <h3 class="card-title">Edit Contact Form</h3>
            </div><!-- /.box-header -->

            <div class="card-body">
                <div class="form-group">
                    <?php echo e(Form::label('title', 'Title')); ?>

                    <?php echo e(Form::text('title', $contact->name, ['class' => 'form-control', 'placeholder' => 'Contact Title', 'required'])); ?>

                </div><!--form group-->
                <div class="form-group">
                    <?php echo e(Form::label('key', 'Key')); ?>

                    <?php echo e(Form::text('key', $contact->slug, ['class' => 'form-control', 'placeholder' => 'Key', 'required'])); ?>

                </div><!--form group-->

                <div class="form-group">
                    <label for="content">Contact Form</label>
                    <?php echo e(Form::textarea('form', null, ['class' => 'form-control'])); ?>

                </div>
                <div class="form-group">
                    <?php echo e(Form::label('email', 'Receiver Email')); ?>

                    <?php echo e(Form::email('email',$contact->receiver_email, ['class' => 'form-control', 'placeholder' => 'Receiver Email', 'required'])); ?>

                </div><!--form group-->
                <div class="form-group">
                    <?php echo e(Form::label('message', 'Success Message')); ?>

                    <?php echo e(Form::text('message', $contact->success_message, ['class' => 'form-control', 'placeholder' => 'Success Message'])); ?>

                </div><!--form group-->
                <div class="form-group">
                    <?php echo e(Form::label('send_email', 'Send Response In Email Too')); ?>

                    <input type="hidden" name="send_in_email" value="0">
                    <input type="checkbox" name="send_in_email" value="1" <?php echo e($contact->send_in_email ? 'checked' : ''); ?>>
                </div><!--form group-->
            </div><!-- /.box-body -->
        </div><!--box-->

        <div class="card">
            <div class="card-body">
                <div class="float-left">
                    <?php echo e(link_to_route('admin.contact.index', trans('buttons.general.cancel'), [], ['class' => 'btn btn-danger btn-xs'])); ?>

                </div><!--pull-left-->

                <div class="float-right">
                    <?php echo e(Form::submit(trans('buttons.general.crud.update'), ['class' => 'btn btn-success btn-xs'])); ?>

                </div><!--pull-right-->

                <div class="clearfix"></div>
            </div><!-- /.box-body -->
        </div><!--box-->

    <?php echo e(Form::close()); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startPush('after-scripts'); ?>

<?php $__env->stopPush(); ?>

<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\arkbo\app\Modules/Contact/Resources/Views/edit.blade.php ENDPATH**/ ?>