<?php
/**
 * @author Rawbinn Shrestha <rawbinnn@gmail.com>
 */
if(config('gear.module.page')):
	Route::group([
		'prefix'     => 'page',
		'as'		 => 'page.',
		'middleware' => 'access.routeNeedsPermission:manage-pages',
	], function() {

		/**
		 * Page Specific Functionality
		 */
		Route::get('/', 'PageController@index')->name('index');

		Route::get('about', 'PageController@about')->name('about');
		Route::post('about', 'PageController@updateAbout')->name('about');

		Route::get('create', 'PageController@create')->name('create');
		Route::post('store', 'PageController@store')->name('store');
		//Route::get('show/{page}', 'PageController@show')->name('show'); //disabled
		Route::get('{page}/edit', 'PageController@edit')->name('edit');
		Route::put('update/{page}', 'PageController@update')->name('update');
		Route::delete('{page}', 'PageController@destroy')->name('destroy');
		Route::get('deleted', 'PageController@deleted')->name('deleted');
		Route::get('destroy', 'PageController@destroySelected')->name('destroySelected');
        Route::get('delete', 'PageController@deleteSelected')->name('deleteSelected');
	});

	/**
	 * Deleted page
	 */
	Route::group(['prefix' => 'page/{deletedPage}', 'middleware' => 'access.routeNeedsPermission:manage-pages',], function() {
		Route::get('delete', 'PageController@delete')->name('page.delete-permanently');
		Route::get('restore', 'PageController@restore')->name('page.restore');
	});

	/**
	 * For DataTables
	 */
	Route::post('pages/get', 'PageController@getForDatatable')->name('pages.get');
endif;