<?php
/**
 * @author Rawbinn Shrestha <rawbinnn@gmail.com>
 */

/*
 * Routes for menu management
 */
if (config('gear.module.menu')):
    Route::group([
        'prefix' => 'menu',
        'as' => 'menu.',
        'middleware' => 'access.routeNeedsPermission:manage-menu',
    ], function () {
        Route::get('/', 'MenuController@index')->name('index');
        Route::post('/', 'MenuController@store')->name('store');
        Route::post('store', 'MenuController@storeGroup')->name('group.store');
        Route::get('show', 'MenuController@show')->name('show');
        Route::get('{id}/edit', 'MenuController@edit')->name('edit');
    });

    /*
     * Route for ajax request
     */
    Route::post('api/menu/add', 'MenuController@add')->name('menu.add');
    Route::post('api/menu/settings', 'MenuController@settings')->name('menu.settings');
    Route::post('api/menu/update', 'MenuController@update')->name('menu.update');
    Route::post('api/menu/select', 'MenuController@select')->name('menu.select');
    Route::post('api/menu/hierarchy', 'MenuController@hierarchy')->name('menu.hierarchy');
    Route::get('api/menu/delete/{menu}', 'MenuController@delete')->name('menu.delete');
endif;
