<?php

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| This file is where you may define all of the routes that are handled
| by your module. Just tell Laravel the URIs it should respond
| to using a Closure or controller method. Build something great!
|
 */

Route::group([
    'prefix' => 'gallery',
    'as' => 'gallery.',
    'middleware' => 'access.routeNeedsPermission:manage-gallery',
], function () {
    Route::get('/', 'GalleryController@index')->name('index');
    Route::get('create', 'GalleryController@create')->name('create');
    Route::post('store', 'GalleryController@store')->name('store');
    Route::get('{id}/edit', 'GalleryController@edit')->name('edit');
    Route::put('{id}/update', 'GalleryController@update')->name('update');
    Route::delete('{id}', 'GalleryController@delete')->name('delete');

    Route::post('get', 'GalleryController@getForDatatables')->name('get');
    Route::post('{id}/items/get', 'GalleryItemController@getForDatatables')->name('items.get');

    Route::get('{id}/items', 'GalleryItemController@index')->name('item.index');
    Route::get('{id}/item/create', 'GalleryItemController@create')->name('item.create');
    Route::post('{id}/item/store', 'GalleryItemController@store')->name('item.store');
    Route::get('item/{id}/edit', 'GalleryItemController@edit')->name('item.edit');
    Route::put('item/{id}/update', 'GalleryItemController@update')->name('item.update');
    Route::delete('item/{id}', 'GalleryItemController@delete')->name('item.delete');
});
