<?php
/**
 * @author Rawbinn Shrestha <rawbinnn@gmail.com>
 */
    Route::group([
        'prefix'     => 'comments',
        'as'		 => 'comments.',
        'middleware' => 'access.routeNeedsPermission:manage-comments',
    ], function() {

        /**
         * Comment Specific Functionality
         */
        Route::get('/', 'CommentController@index')->name('index');
        Route::delete('{comment}', 'CommentController@destroy')->name('destroy');
        Route::get('deleted', 'CommentController@deleted')->name('deleted');
        Route::get('trash/empty', 'CommentController@emptyTrash')->name('empty.trash');
        Route::get('{comment}/status/approve', 'CommentController@approve')->name('status.approve');
        Route::get('{comment}/status/unapprove', 'CommentController@unapprove')->name('status.unapprove');
    });

    /**
     * Deleted comment
     */
    Route::group(['prefix' => 'comment/{deletedComment}'], function() {
        Route::get('delete', 'CommentController@delete')->name('comments.delete-permanently');
        Route::get('restore', 'CommentController@restore')->name('comments.restore');
    });

    /**
     * For DataTables
     */
    Route::post('comments/get', 'CommentController@getForDatatable')->name('comments.get');