<?php
/**
 * @author Rawbinn Shrestha <rawbinnn@gmail.com>
 */
if (config('gear.module.blogs')):
    Route::group([
        'prefix' => 'blog',
        'as' => 'blog.',
        'middleware' => 'access.routeNeedsPermission:manage-blogs',
    ], function () {
        /*
         * Blog Specific Functionality
         */
        Route::get('/', 'BlogController@index')->name('index');
        Route::get('create', 'BlogController@create')->name('create');
        Route::post('store', 'BlogController@store')->name('store');
        //Route::get('show/{blog}', 'BlogController@show')->name('show'); //disabled
        Route::get('{post}/edit', 'BlogController@edit')->name('edit');
        Route::put('{post}/update', 'BlogController@update')->name('update');
        Route::get('destroy', 'BlogController@destroySelected')->name('destroySelected');
        Route::get('delete', 'BlogController@deleteSelected')->name('deleteSelected');
        Route::delete('{post}', 'BlogController@destroy')->name('destroy');
        Route::get('deleted', 'BlogController@deleted')->name('deleted');
    });

    /*
     * Deleted blog
     */
    Route::group(['prefix' => 'blog/{deletedBlog}', 'middleware' => 'access.routeNeedsPermission:manage-blogs'], function () {
        Route::get('delete', 'BlogController@delete')->name('blog.delete-permanently');
        Route::get('restore', 'BlogController@restore')->name('blog.restore');
    });

    /*
     * For DataTables
     */
    Route::post('blogs/get', 'BlogController@getForDatatable')->name('blogs.get');
endif;
