<?php
/**
 * @author Rawbinn Shrestha <rawbinnn@gmail.com>
 */
    Route::group([
        'prefix' => 'block',
        'as' => 'block.',
        'middleware' => 'access.routeNeedsPermission:manage-blocks',
    ], function () {
        /*
         * Blog Specific Functionality
         */

        Route::get('create', 'BlockController@create')->name('create');
        Route::post('store', 'BlockController@store')->name('store');
        Route::get('{block}/edit', 'BlockController@edit')->name('edit');
        Route::put('update/{block}', 'BlockController@update')->name('update');
        Route::delete('{block}', 'BlockController@destroy')->name('destroy');
        Route::post('preview', 'BlockController@preview')->name('preview');
    });
    Route::get('blocks', 'BlockController@index')->name('block.index');
    /*
     * For DataTables
     */
    Route::post('blocks/get', 'BlockController@getForDatatable')->name('blocks.get');

    Route::get('widgets', 'WidgetController@index')->name('widgets');
    Route::post('widgets', 'WidgetController@store')->name('widgets.store');
    Route::delete('widget/{widget}', 'WidgetController@destroy')->name('widget.destroy');
    Route::post('widget/box/store', 'WidgetController@widgetBlockUpdate')->name('widget.box.store');
    Route::delete('widget/box/delete', 'WidgetController@widgetBlockDelete')->name('widget.box.delete');
