@extends ('admin.layouts.app')

@section ('title', 'Widget Management')

@section('page-header')
    <h1>
        Widget Management
    </h1>
@endsection

@section('after-styles')
<style type="text/css">
    #block_form, #widget_form{
        display: none;
    }
    .woogento-widget-list-box{
        border: 1px solid #ece8e8;
        cursor: pointer;
    }
    .woogento-widget-list-box h3{
      font-size: 14px!important;
    }
    .woogento-widget-list-box .woogent-widget-card-header{
      padding: 7px 10px;
    }
    .woogento-widget-box>div>h3{
      font-size: 16px!important;
    }
</style>
@endsection

@section('content')

<div class="col-md-12">
<div class="row">
<div class="col-md-4">
  {{ Form::open(['route'=> 'admin.widgets.store', 'role' => 'form', 'method' => 'post']) }}
      <div class="card">
          <div class="card-header with-border">
              <h3 class="card-title">Widget Area</h3>

              <div class="card-tools float-right">
                  <!-- Include your header buttons -->
              </div><!--card-tools float-right-->
          </div><!-- /.card-header -->

          <div class="card-body">
              <div class="form-group">
                  {{ Form::label('title', 'Title') }}
                  {{ Form::text('title', null, ['class' => 'form-control', 'id'=> 'block-title', 'placeholder' => 'Title', 'required']) }}
              </div><!--form control-->
              <input type="checkbox" name="show"> Show title
              <div class="form-group">
                  {{ Form::label('identifier', 'Identifier') }}
                  {{ Form::text('identifier', null, ['class' => 'form-control', 'id'=>'block-identifier', 'placeholder' => 'Identifier']) }}
              </div><!--form control-->
              <div class="form-group">
                  <label>Choose Content From</label>
                  <select name="content_from" class="form-control" id="content_from">
                      <option value="0">Choose Content From</option>
                      <option value="block">From Blocks</option>
                      <option value="widget_plugin">From Widget Plugin</option>
                  </select>
              </div>
              <div class="form-group" id="block_form">
                  <label>Block list</label>
                  <select name="block" class="form-control">
                      <option value="0">Choose block...</option>
                      @foreach($blocks as $block)
                          <option value="{{ $block->slug }}">{{ $block->title }}</option>
                      @endforeach
                  </select>
              </div>
              <div class="form-group" id="widget_form">
                  <label>Widget Plugin list</label>
                  <select name="widget_plugin" class="form-control">
                      <option value="0">Choose widget plugin...</option>
                      <option value="popular_products">Popular Products</option>
                      <option value="primary_menu">Primary Menu</option>
                      <option value="search">Search</option>
                  </select>
              </div>
              <div class="form-group">
                  <label>Display Area</label>
                  <select name="display" class="form-control">
                      <option value="0">Choose display area...</option>
                      @foreach($display as $area)
                          <option value="{{ $area['slug'] }}">{{ $area['title'] }}</option>
                      @endforeach
                  </select>
              </div>
            
              <div class="form-group">
                  {{ Form::submit(trans('buttons.general.save'), ['class' => 'btn btn-success btn-md float-right']) }}
              </div><!--form control-->
              
          </div><!-- /.card-body -->
      </div><!--box-->
  {{ Form::close() }}
</div>
<div class="col-md-8">
    <div class="card">
        <div class="card-header with-border">
            <h3 class="card-title">Widget List</h3>

            <div class="card-tools float-right">
                <!-- Include your header buttons -->
            </div><!--card-tools float-right-->
        </div><!-- /.card-header -->

        <div class="card-body">
          @foreach($display as $display_area)
            @if($loop->iteration % 2 == 1)
            <div class="row">
            @endif
              <div class="col-md-6">
                  <div class="card woogento-widget-box">
                    <div class="card-header with-border">
                      <h3 class="card-title">{{ $display_area['title'] }}</h3>

                      <div class="card-tools">
                        <button type="button" class="btn btn-tool" data-card-widget="collapse">
                          <i class="fas fa-minus"></i>
                        </button>
                      </div>
                      <!-- /.card-tools -->
                    </div>
                    <!-- /.card-header -->
                    <div class="card-body collapsed-box" style="">
                    @foreach(Larapress::getWidgetData($display_area['slug']) as $widget)
                      <div class="box woogento-widget-list-box collapsed-box" id="widget-{{ $widget->id }}">
                        <div class="card-header with-border woogent-widget-card-header">
                          <h3 class="card-title">{{ $widget->title }}</h3>

                          <div class="card-tools">
                            <button type="button" class="btn btn-tool" data-card-widget="collapse">
                              <i class="fas fa-minus"></i>
                            </button>
                          </div>
                          <!-- /.card-tools -->
                        </div>
                        <!-- /.card-header -->
                        <div class="card-body">
                          <form method="post" class="woogento-widget-block-form" action="{{ route('admin.widget.box.store') }}">
                          {{ csrf_field() }}
                          @if($widget->type=='block')
                              @php
                                $block = DB::table('blocks')->where('slug',$widget->content)->first();
                              @endphp
                                <div class="form-group">
                                  <label for="title">Title</label>
                                  <input type="text" class="form-control" id="title" name="title" value="{{ $block->title }}">
                                </div>
                                <input type="checkbox" name="show" {{ ($widget->show_title=='1') ? 'checked': '' }}>Show Title
                                
                                <div class="form-group">
                                  <label for="title">Block Name</label>
                                  <select name="block" id="block" class="form-control">
                                  @foreach($blocks as $block_list)
                                      <option value="{{ $block_list->slug }}" {{ ($block_list->slug==$block->slug)?'selected':'' }}>{{ $block_list->title }}</option>
                                  @endforeach
                                  </select>
                                </div>
                                <input type="hidden" name="widget_slug" value="{{ $widget->slug }}">
                          @endif    

                          <a href="#" data-url = "{{ route('admin.widget.box.delete') }}" data-id={{ $widget->id }} class="woogento-widget-block-delete">Delete</a> 
                                <button type="submit" class="btn btn-sm btn-primary float-right">Save</button>
                          </form>
                        </div>
                        <!-- /.card-body -->
                      </div>
                      @endforeach
                    </div>
                    <!-- /.card-body -->
                  </div>
                  <!-- /.card -->
              </div>
            @if($loop->iteration % 2 == 0)
            </div>
            @endif
                    
          @endforeach
        </div>
    </div>
</div>
</div>
</div>

@stop

@push('after-scripts')
<script type="text/javascript">
$(function() {
    $('.woogento-widget-block-delete').click(function(event)  {
        event.preventDefault();
        var id = $(this).data('id');
        var url = $(this).data('url');
        var token ="{{ csrf_token() }}";
        swal.fire({
              title: "Are you sure?",
              text: "You will not be able to recover this widget!",
              type: "warning",
              showCancelButton: true,
              confirmButtonColor: "#DD6B55",
              confirmButtonText: "Yes, delete it!",
            }).then((result) => {
              if (result.value) {
                    $.ajax({
                        url: url,
                        type: 'POST',
                        dataType: 'json',
                        data:{id:id,_token:token,_method:'delete'},
                    })
                    .done(function(data) {
                        if (data.status){
                            $('#widget-'+id).remove();
                            toastr.success("{!! trans('alerts.backend.general.deleted',['attribute' => 'widget']) !!}");
                        }
                        else{
                            toastr.error(data.msg);
                        }                
                    })
                    .fail(function(data) {
                       toastr.error(data.responseJSON.msg);
                    });
                }
            }); 
        
    });
    $('#content_from').on('change', function() {
      if( this.value == 'block'){
        $('#widget_form').hide();
          $('#block_form').show();
        }
        else if(this.value == 'widget_plugin') {
            $('#block_form').hide();
            $('#widget_form').show();
        }
        else{
            $('#widget_form').hide();
            $('#block_form').hide();
        }
      });

    $(".woogento-widget-block-form").submit(function(event) {
       /* stop form from submitting normally */
        event.preventDefault();

        /* get some values from elements on the page: */
        var $form = $(this),
            title = $form.find('input[name="title"]').val(),
            slug = $form.find('input[name="widget_slug"]').val(),
            show = $form.find('input[name="show"]').is(':checked'),
            block = $form.find(":selected").val(),
            url = $form.attr('action');

            $.ajax({
              url: url,
              type: 'POST',
              dataType: 'json',
              data: {title: title,show:show,content:block,slug:slug, _token: Laravel.csrfToken},
            })
            .done(function(data) {
                if(data==true)
                    toastr.success("Widget updated successfully");
                else
                    toastr.error("There is some error occured during updating widget");

              console.log("success");
            })
            .fail(function() {
              console.log("error");
            })
            .always(function() {
              console.log("complete");
            });
            

    });
  });
</script>
@endpush
