@extends ('admin.layouts.app')

@section ('title', trans('labels.backend.theme.management'))

@section('page-header')
    <h1 style="float:left;">
        {{ trans('labels.backend.theme.management') }}
    </h1>
    <div class="theme-upload">
        <form enctype="multipart/form-data" method="post" action="{{route('admin.themes.upload')}}">
            {{csrf_field()}}
            <div class="row">
            <div class="col-md-5">
                <input type="file" name="theme">
            </div>
            <div class="col-md-3">
                <button type="submit" class="btn btn-primary btn-xs">Upload</button>
            </div>
            </div>
        </form>
    </div>
@endsection

@section('after-styles')
<style type="text/css">
  .larapress-theme-box img{
    width: 290px;
    height: auto;
    border-radius: 4px;
    box-shadow: 0 1px 3px rgba(0,0,0,.15);
  }
  .larapress-theme-box p{
    line-height: 16px;
  }
  .content{
      clear: both;
  }
  .media-body{
    margin-left: 10px;
  }
</style>
@endsection

@section('content')

{!! Form::open(['route' => 'admin.themes.update', 'class' => 'form-horizontal']) !!}
  <div class="row">
    <div class="col-md-8">
        <div class="card">
        <div class="card-header with-border">
          <h3 class="card-title">Theme Settings</h3>
        </div>
          <div class="card-body">
                <div class="media larapress-theme-box">
                    <div class="media-left">
                            <img src="{{ $theme['image'] }}" alt="{{ $theme['name'] }}" class="media-object">
                        
                    </div>
                    <div class="media-body">
                        <div class="clearfix">
                            <p class="float-right">
                                <a href="{{ $theme['theme_url'] }}" class="btn btn-success btn-sm">
                                    View Website
                                </a>
                            </p>

                            <h4 style="margin-top: 0">{{ $theme['name'] }}</h4>
                            <p>Author: <a href="{{ $theme['author_url'] }}">{{ $theme['author'] }}</a></p>
                            <p>Version: {{ $theme['version'] }}</p>

                            <p>{{ $theme['description'] }}</p>
                            
                        </div>
                    </div>
                </div>
          </div>
          <!-- /.card-body -->
        </div>
    </div>
    <div class="col-md-4">
      <div class="card">
        <div class="card-header with-border">
          <h3 class="card-title">Active Theme</h3>
        </div>
        <!-- /.card-header -->
          <div class="card-body">
            <div class="form-group col-md-12">
                  <select class="form-control" name="active_theme">
                  @foreach($allThemes as $themeName)
                      <option value="{{$themeName}}" {{ (setting('theme-active') == $themeName) ? 'selected' : '' }}>{{ ucfirst($themeName) }}</option>
                  @endforeach
                  </select>
            </div>
          </div>
          <!-- /.card-body -->
      </div>
    </div>
  </div>
  <div class="row">
    <div class="col-md-12">
      <div class="card">
          <div class="card-body">
            
              <div class="float-right">
                  {{ Form::submit(trans('buttons.general.crud.update'), ['class' => 'btn btn-success btn-xs']) }}
              </div><!--float-right-->

              <div class="clearfix"></div>
          </div><!-- /.card-body -->
      </div><!--box-->
    </div>
  </div>
{{ Form::close() }}
@stop

@push('after-scripts')

@endpush
