{{ Form::model($tag, ['role' => 'form', 'id' => 'tagForm', 'method' => 'put']) }}

        <div class="card">
            <div class="card-header with-border">
                <h3 class="card-title">{{ trans('labels.backend.tag.edit') }}</h3>

                <div class="card-tools float-right">
                    <!-- Include your header buttons -->
                </div><!--card-tools float-right-->
            </div><!-- /.card-header -->

            <div class="card-body">
                <div class="form-group">
                    {{ Form::label('title', trans('validation.attributes.backend.tag.title')) }}
                    {{ Form::text('title', null, ['class' => 'form-control', 'placeholder' => trans('validation.attributes.backend.tag.title')]) }}
                </div><!--form control-->

                <div class="form-group">
                    {{ Form::label('slug', trans('validation.attributes.backend.tag.slug')) }}
                    {{ Form::text('slug', null, ['class' => 'form-control', 'placeholder' => trans('validation.attributes.backend.tag.slug')]) }}
                </div><!--form control-->

                <div class="form-group">
                    {{ Form::label('description', trans('validation.attributes.backend.tag.description')) }}
                    {{ Form::textarea('description', null, ['size' => '30x5', 'class' => 'form-control', 'placeholder' => trans('validation.attributes.backend.tag.description')]) }}
                </div><!--form control-->
                
                <input type="hidden" name="id" value="{{$tag->id}}">
            </div><!-- /.card-body -->
        </div><!--box-->

        <div class="card">
            <div class="card-body">
                <div class="float-left">
                    {{ link_to_route('admin.tag.create', trans('buttons.general.cancel'), [], ['class' => 'btn btn-danger btn-xs']) }}
                </div><!--float-left-->

                <div class="float-right">
                    {{ Form::submit(trans('buttons.general.crud.update'), ['class' => 'btn btn-success btn-xs']) }}
                </div><!--float-right-->

                <div class="clearfix"></div>
            </div><!-- /.card-body -->
        </div><!--box-->

    {{ Form::close() }}
