@extends ('admin.layouts.app')

@section ('title', trans('labels.backend.tag.create'))

@section('page-header')
    <h1>
        {{ trans('labels.backend.tag.management') }}
        <small>{{ trans('labels.backend.tag.create') }}</small>
    </h1>
@endsection

@section('after-styles')
<style>

</style>
@endsection

@section('content')
<div class="col-md-12">
    <div class="row">
        <div class="col-md-5">
            <div class="alert alert-success alert-dismissable" style="display: none">
            </div>
            <div id="editTagForm">

            </div>
            <div id="addTagForm">
                {{ Form::open(['route' => 'admin.tag.create', 'role' => 'form', 'method' => 'post']) }}

                    <div class="card">
                        <div class="card-header with-border">
                            <h3 class="card-title">{{ trans('labels.backend.tag.create') }}</h3>

                            <div class="card-tools float-right">
                                <!-- Include your header buttons -->
                            </div><!--card-tools float-right-->
                        </div><!-- /.card-header -->

                        <div class="card-body">
                            <div class="form-group">
                                {{ Form::label('title', trans('validation.attributes.backend.tag.title')) }}
                                {{ Form::text('title', null, ['class' => 'form-control', 'placeholder' => trans('validation.attributes.backend.tag.title')]) }}
                            </div><!--form control-->

                            <div class="form-group">
                                {{ Form::label('slug', trans('validation.attributes.backend.tag.slug')) }}
                                {{ Form::text('slug', null, ['class' => 'form-control', 'placeholder' => trans('validation.attributes.backend.tag.slug')]) }}
                            </div><!--form control-->

                            <div class="form-group">
                                {{ Form::label('description', trans('validation.attributes.backend.tag.description')) }}
                                {{ Form::textarea('description', null, ['size' => '30x5', 'class' => 'form-control', 'placeholder' => trans('validation.attributes.backend.tag.description')]) }}
                            </div><!--form control-->
                    
                        </div><!-- /.card-body -->
                    </div><!--box-->

                    <div class="card">
                        <div class="card-body">
                            <div class="float-left">
                                {{ link_to_route('admin.tag.create', trans('buttons.general.cancel'), [], ['class' => 'btn btn-danger btn-xs']) }}
                            </div><!--float-left-->

                            <div class="float-right">
                                {{ Form::submit(trans('buttons.general.crud.create'), ['class' => 'btn btn-success btn-xs']) }}
                            </div><!--float-right-->

                            <div class="clearfix"></div>
                        </div><!-- /.card-body -->
                    </div><!--box-->

                {{ Form::close() }}
            </div>
        </div>
        <div class="col-md-7">
            <div class="card">
                <div class="card-header with-border">
                    <h3 class="card-title">{{ trans('labels.backend.tag.all') }}</h3>

                    <div class="card-tools float-right">
                        <!-- Include your header buttons -->
                    </div><!--card-tools float-right-->
                </div><!-- /.card-header -->

                <div class="card-body">
                    <div class="table-responsive">
                    <table class="table table-hover tagtable">
                        <tbody>
                            <tr>
                            <th>Name</th>
                            <th>Description</th>
                            <th>Slug</th>
                            <th>Count</th>
                            <th>Actions</th>
                            </tr>
                            @include('admin.tag.list',['parents' => $tags])
                            
                        </tbody>
                        
                    </table>
                    </div>
                    {{$tags->links()}}
                </div><!-- /.card-body -->
            </div><!--box-->
        </div>
    </div>
</div>
@stop

@push('after-scripts')
   <script>
    $(document).ready(function(){

    
        // Edit Tag Form Display /////////////////////////////////////////////////////
        $('.editTag').click(function(event) {
            event.preventDefault();
            var url = $(this).attr('href');
            $.get(url, function(data) {
                $('#addTagForm').hide();
                $('#editTagForm').html(data);
            })
            .done(function() {
                console.log( "second success" );
            })
            .fail(function() {
                alert( "error" );
            })
            .always(function() {
                console.log( "finished" );
            });
        });
        // End ///////////////////////////////////////////////////////////////////////
        
    // Submit new menu form data ///////////////////////////////////////////////////
    $(document).on('submit', '#tagForm', function(event) {
        event.preventDefault();
        var _data = $(this).serialize();
        $.ajax({
            url: base_url + '/admin/tag/update',
            type: 'POST',
            dataType: 'json',
            data: _data
        })
        .done(function(data) {
            $('#tagForm').find("input[type=text], textarea").val("");
            $('#tagForm .alert').show();
            $('#tagForm .alert').html('Tag updated successfully.');
            setTimeout(function() {
                $('#tagForm .alert').fadeOut();
            }, 5000);
            location.reload();
        })
        .fail(function(data) {
            console.log(data);
        });

    });
    // End /////////////////////////////////////////////////////////////////////////
    $('.tagtable').on('click', '.deleteTag', function(event) {
            event.preventDefault();
            var id = $(this).parent().parent().data('id');
            Swal.fire({
                title: "Are you sure?",
                text: "You will not be able to recover this tag!",
                icon: "warning",
                showCancelButton: true
            }).then((result) => {
                if (result.value)
                {
                    
                    $.ajax({
                        url: base_url + '/admin/api/tag/delete',
                        type: 'POST',
                        data: { id:id, _token:Laravel.csrfToken }
                    })
                    .done(function (data) {
                        if (data.status) {
                            $('#row-' + id).remove();
                            toastr.success("{!! trans('alerts.backend.general.deleted',['attribute' => 'tag']) !!}");
                        }
                        else {
                            toastr.error(data.msg);
                        }
                    })
                    .fail(function (data) {
                        toastr.error(data.responseJSON.msg);
                    });
                }
            });
        });

    
    });
   </script>
@endpush
