@extends ('admin.layouts.app')

@section ('title', trans('labels.backend.slider.management') . ' | ' . trans('labels.backend.slider.create'))

@section('page-header')
    <h1>
        {{ trans('labels.backend.slider.management') }}
        <small>{{ trans('labels.backend.slider.create') }}</small>
    </h1>
@endsection

@section('content')
    {{ Form::open(['route' => 'admin.slider.store', 'role' => 'form', 'method' => 'post']) }}

        <div class="card">
            <div class="card-header with-border">
                <h3 class="card-title">{{ trans('labels.backend.slider.create') }}</h3>

                <div class="card-tools float-right">
                    <!-- Include your header buttons -->
                </div><!--card-tools float-right-->
            </div><!-- /.card-header -->

            <div class="card-body">
                <div class="form-group">
                    {{ Form::label('name', trans('validation.attributes.backend.slider.name')) }}
                    {{ Form::text('name', null, ['class' => 'form-control', 'placeholder' => trans('validation.attributes.backend.slider.name')]) }}
                </div><!--form control-->

                <div class="form-group">
                    
                </div><!--form control-->
            </div><!-- /.card-body -->
        </div><!--box-->

        <div class="card">
            <div class="card-body">
                <div class="float-left">
                    {{ link_to_route('admin.slider.index', trans('buttons.general.cancel'), [], ['class' => 'btn btn-danger btn-xs']) }}
                </div><!--float-left-->

                <div class="float-right">
                    {{ Form::submit(trans('buttons.general.crud.create'), ['class' => 'btn btn-success btn-xs']) }}
                </div><!--float-right-->

                <div class="clearfix"></div>
            </div><!-- /.card-body -->
        </div><!--box-->

    {{ Form::close() }}
@stop

@section('after-scripts')
   
@stop
