@extends ('admin.layouts.app')

@section ('title', trans('labels.backend.settings.management') . ' | ' . trans('labels.backend.page.create'))

@section('page-header')
    <h1>
        {{ trans('labels.backend.settings.management') }}
        <small>{{ trans('labels.backend.settings.seo') }}</small>
    </h1>
@endsection

@section('content')
    {{ Form::open(['route' => 'admin.setting.seo', 'role'=> 'form', 'method' => 'post']) }}

        <div class="card">
            <div class="card-header with-border">
                <h3 class="card-title">{{ trans('labels.backend.settings.seo') }}</h3>

                <div class="card-tools float-right">
                    <!-- Include your header buttons -->
                </div><!--card-tools float-right-->
            </div><!-- /.card-header -->

            <div class="card-body">
                <div class="form-group">
                    {{ Form::label('site-title', trans('validation.attributes.backend.settings.meta-description')) }}
                    {{ Form::textarea('meta_description', setting('meta-description','Meta Description'), ['class' => 'form-control', 'placeholder' => trans('validation.attributes.backend.settings.meta-description')]) }}
                </div><!--form control-->

                <div class="form-group">
                     {{ Form::label('site-tagline', trans('validation.attributes.backend.settings.meta-keywords')) }}
                    {{ Form::text('meta_keywords', setting('meta-keywords','Meta Keywords'), ['class' => 'form-control', 'placeholder' => trans('validation.attributes.backend.settings.meta-keywords')]) }}
                </div>

                <div class="form-group">
                    
                </div><!--form control-->
            </div><!-- /.card-body -->
        </div><!--box-->

        <div class="card">
            <div class="card-body">
                <div class="float-left">
                    {{ link_to_route('admin.dashboard', trans('buttons.general.cancel'), [], ['class' => 'btn btn-danger btn-xs']) }}
                </div><!--float-left-->

                <div class="float-right">
                    {{ Form::submit(trans('buttons.general.crud.update'), ['class' => 'btn btn-success btn-xs']) }}
                </div><!--float-right-->

                <div class="clearfix"></div>
            </div><!-- /.card-body -->
        </div><!--box-->

    {{ Form::close() }}
@stop
@push('after-scripts')

@endpush
