@extends ('admin.layouts.app')

@section ('title', 'All Review')

@section('page-header')
    <h1>
        Review Management
        <small>All Review</small>
    </h1>
@endsection

@section('after-styles')
  <!-- DataTables -->
  {{ style('vendor/datatables-bs4/css/dataTables.bootstrap4.min.css') }}
  {{ style('vendor/datatables-responsive/css/responsive.bootstrap4.min.css') }}
@stop

@section('content')
<div class="col-md-12">
<div class="row">
<div class="card">
        <div class="card-header with-border">
            <h3 class="card-title">All Review</h3>

            <div class="card-tools float-right">
                <!-- Include your header buttons -->
            </div><!--card-tools float-right-->
        </div><!-- /.card-header -->

        <div class="card-body">
            <div class="table-responsive">
                <table id="reviews-table" class="table table-condensed table-hover">
                    <thead>
                    <tr>
                        <th>Author</th>
                        <th>Review</th>
                        <th>Product</th>
                        <th>Review Date</th>
                        <th>{{ trans('labels.general.actions') }}</th>
                    </tr>
                    </thead>
                </table>
            </div><!--table-responsive-->
        </div>
</div> 
</div>
</div>
@stop

@push('after-scripts')
 {{ script("vendor/datatables/jquery.dataTables.min.js") }}
 {{ script("vendor/datatables/dataTables.bootstrap.min.js") }}

    <script>
        $(function() {
            $('#reviews-table').DataTable({
                processing: true,
                serverSide: true,
                iDisplayLength: 25,
                ajax: {
                    url: '{{ route("admin.reviews.get") }}',
                    type: 'post',
                    data: {trashed: false, _token: Laravel.csrfToken}
                },
                columns: [
                    {data: 'name', name: 'name', sortable: false},
                    {data: 'content', name: 'content'},
                    {data: 'product', name: 'product'},
                    {data: 'created_at', name: 'created_at'},
                     {data: 'actions', name: 'actions', searchable: false, sortable: false}
                ],
                searchDelay: 500
            });
        });
    </script>
@endpush
