@extends ('admin.layouts.app')

@section('title', trans('labels.backend.page.create'))

@section('page-header')
    <h1>
        {{ trans('labels.backend.page.management') }}
        <small>{{ trans('labels.backend.page.create') }}</small>
    </h1>
@endsection

@section('after-styles')

@endsection

@section('content')
    {{ Form::open(['route' => 'admin.page.store', 'role' => 'form', 'method' => 'post', 'id' => 'postForm']) }}
    <div class="row">
        <div class="col-md-8">
            <div class="card">
                <div class="card-header with-border">
                    <h3 class="card-title">{{ trans('labels.backend.page.create') }}</h3>
                </div><!-- /.card-header -->

                <div class="card-body">
                    <div class="form-group">
                        {{ Form::label('title', trans('validation.attributes.backend.page.title')) }}
                        {{ Form::text('title', null, ['class' => 'form-control','placeholder' => trans('validation.attributes.backend.page.title')]) }}
                    </div>
                    <div class="form-group">
                        {{ Form::label('subtitle', trans('validation.attributes.backend.page.subtitle')) }}
                        {{ Form::textarea('subtitle', null, ['class' => 'form-control seshra-text-editor','data-airmode' => 'true','placeholder' => trans('validation.attributes.backend.page.subtitle')]) }}
                    </div>
                    <div class="form-group">
                        <label for="content">Content</label>
                        <textarea class="seshra-text-editor" name="content" data-min-height="300"
                            data-image-submit-url="{{ route('admin.image.upload') }}" data-format="true"
                            data-image-group="blogs">{!! old('content') !!}</textarea>
                    </div>
                    <div class="form-group">
                        <label for="meta-title" class="meta-title">Meta Title <small>(Recommended less than 60
                                characters) <span id="meta_title_length"></span></small></label>
                        {{ Form::text('meta_title', null, ['class' => 'form-control','placeholder' => 'Meta Title','id' => 'meta-title']) }}
                    </div>
                    <div class="form-group">
                        <label for="meta-description" class="meta-description">Meta Description <small>(Recommended less
                                than 160 characters) <span id="meta_description_length"></span></small></label>
                        {{ Form::textarea('meta_description', null, ['class' => 'form-control','rows' => '4','id' => 'meta-description']) }}

                    </div>
                </div><!-- /.card-body -->

            </div>
            <!--box-->
            <div id="dynamic-block-container">

            </div>
            <div class="row mb-5">
                <div class="col-md-12">
                    <div class="btn-group dropup float-right" id="dynamic-text-block">
                        <button type="button" class="btn btn-primary" data-toggle="modal" data-target="#dynamic-block-modal">
                            Add Block
                        </button>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-4">
            <div class="card">
                <div class="card-header with-border">
                    <h3 class="card-title">Page Template</h3>
                </div><!-- /.card-header -->

                <div class="card-body">
                    <div class="form-group">
                        <select name="template" class="form-control">
                            <option value="default">Default</option>
                            @if ($templates != null)
                                @foreach ($templates as $template_slug => $template)
                                    <option value="{{ $template_slug }}">{{ $template }}</option>
                                @endforeach
                            @endif
                        </select>

                    </div>
                    <!--form group-->
                </div>
            </div>
            <div class="card">
                <div class="card-header with-border">
                    <h3 class="card-title">Featured</h3>
                </div><!-- /.card-header -->

                <div class="card-body">
                    <div class="form-group">
                        <div class="input-group" data-toggle="seshra-uploader" data-type="image" data-group="blogs">
                            <div class="input-group-prepend">
                                <div class="input-group-text bg-soft-secondary font-weight-medium">Browse</div>
                            </div>
                            <div class="form-control file-amount">Choose File</div>
                            <input type="hidden" name="featured_image" class="selected-files">
                        </div>
                        <div class="file-preview box sm">
                        </div>
                    </div>
                </div><!-- /.card-body -->
            </div>
            <!--box-->
            <div class="card position-sticky" style="top: 30px">
                <div class="card-body">
                    <div class="form-group">
                        {{ Form::submit(trans('buttons.general.save'), ['class' => 'btn btn-success btn-md']) }}
                        <input type="submit" name="saveEdit" id="saveEdit" value="Save & Edit"
                            class="btn btn-success btn-md">
                    </div>
                </div>
                <!--form control-->
            </div>
            <!--box-->
        </div>
    </div>
    {{ Form::close() }}
    <div class="modal fade" id="dynamic-block-modal" tabindex="-1" role="dialog" aria-labelledby="dynamic-block-label"
        aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel">Add Block</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                    <div class="modal-body">
                        <div class="form-group">
                            <label>Column</label>
                            <select class="form-control" name="cols" id="block_cols">
                                <option value="1">1</option>
                                <option value="2">2</option>
                                <option value="3">3</option>
                                <option value="4">4</option>
                            </select>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                        <button type="button" class="btn btn-primary" id="add-block">Add</button>
                    </div>
                
            </div>
        </div>
    </div>
@stop

@push('after-scripts')
    <script>
        $(function() {
            var block = 1;
            var item=1
            $(document).on('click', '#add-block', function(e) {
                e.preventDefault();
                loading();
                var cols = $('#block_cols').val();
                $.ajax({
                    url: "{{ route('admin.dynamic.addblock') }}",
                    type: "GET",
                    data: {
                        cols: cols,
                        block: block,
                    },
                    success: function(data) {
                        $('#dynamic-block-container').append(data);
                        block = block + 1;
                        item = 1;                   
                    },
                    error: function() {

                    },
                    complete: function() {
                        loading(false);
                    }

                });  
                $('#dynamic-block-modal').modal('hide')      
                
            });
            
            $(document).on('click', '.dynamic-block a', function(e) {
                e.preventDefault();
                var _this = $(this);
                var type = $(this).data('type');
                var col = $(this).data('col');
                var cols = $(this).data('cols');
                var block = $(this).data('block');
                loading();
                $.ajax({
                    url: "{{ route('admin.dynamic.block') }}",
                    type: "GET",
                    data: {
                        type: type,
                        col: col,
                        cols: cols,
                        block: block,
                        item: item
                    },
                    success: function(data) {
                        _this.closest('.dynamic-items-holder').find('.dynamic-block-items').append(data);
                        LARAPRESS.plugins.reload('textarea');
                        item = item+1;
                    },
                    error: function() {

                    },
                    complete: function() {
                        loading(false);
                    }
                });      
                
            });

            $(document).on('click', '.delete-block-item', function(e) {
                e.preventDefault();
                var key =  $(this).data('key');
                Swal.fire({
                    title: 'Are you sure want to delete this block?',
                    showCancelButton: true,
                    confirmButtonText: 'Yes'
                }).then((result) => {
                    if (result.isConfirmed) {                        
                        $('#'+key).remove();
                        LARAPRESS.plugins.notify('success', 'Block has been deleted successfully.');
                    }
                });             
            });

            $(document).on('click', '.delete-meta-item', function(e) {
                e.preventDefault();
                e.preventDefault();
                var key =  $(this).data('key');
                var col =  $(this).data('col');
                var item =  $(this).data('item');
                var card =key+col+item;
                Swal.fire({
                    title: 'Are you sure want to delete this block item?',
                    showCancelButton: true,
                    confirmButtonText: 'Yes'
                }).then((result) => {
                    if (result.isConfirmed) {                        
                        $('#'+card).remove();
                        LARAPRESS.plugins.notify('success', 'Block item has been deleted successfully.');
                    }
                });     
            });

            $(document).on('click', '#saveEdit', function(e) {
                $("<input>").attr({
                    name: "saveEdit",
                    id: "savenedit",
                    type: "hidden",
                    value: 'saveEdit'
                }).appendTo("#postForm");

                $('#postForm').submit();
            });

            $('#meta-title').on('keyup', function() {
                var length = $(this).val().length;
                if (length > 60) {
                    $('#meta_title_length').addClass('red');
                    $('#meta_title_length').removeClass('green');
                } else {
                    $('#meta_title_length').removeClass('red');
                    $('#meta_title_length').addClass('green');
                }
                $('#meta_title_length').html(length + ' characters');
            });

            $('#meta-description').on('keyup', function() {
                var length = $(this).val().length;
                if (length > 160) {
                    $('#meta_description_length').addClass('red');
                    $('#meta_description_length').removeClass('green');
                } else {
                    $('#meta_description_length').removeClass('red')
                    $('#meta_description_length').addClass('green');;
                }
                $('#meta_description_length').html(length + ' characters');
            });
        });
    </script>
@endpush
