<!doctype html>
<html class="no-js" lang="en">
    <head>
        <meta charset="utf-8">
        <meta http-equiv="X-UA-Compatible" content="IE=edge">
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <meta name="csrf-token" content="{{ csrf_token() }}">
        <meta name="app-url" content="{{ url('/') }}">
        <title>@yield('title', setting('site-title','LARAPRESS'))  ‹ {{setting('site-title', 'Larapress')}}</title>
        <link rel="apple-touch-icon" sizes="57x57" href="{{public_asset('images/favicon/apple-icon-57x57.png')}}">
        <link rel="apple-touch-icon" sizes="60x60" href="{{public_asset('images/favicon/apple-icon-60x60.png')}}">
        <link rel="apple-touch-icon" sizes="72x72" href="{{public_asset('images/favicon/apple-icon-72x72.png')}}">
        <link rel="apple-touch-icon" sizes="76x76" href="{{public_asset('images/favicon/apple-icon-76x76.png')}}">
        <link rel="apple-touch-icon" sizes="114x114" href="{{public_asset('images/favicon/apple-icon-114x114.png')}}">
        <link rel="apple-touch-icon" sizes="120x120" href="{{public_asset('images/favicon/apple-icon-120x120.png')}}">
        <link rel="apple-touch-icon" sizes="144x144" href="{{public_asset('images/favicon/apple-icon-144x144.png')}}">
        <link rel="apple-touch-icon" sizes="152x152" href="{{public_asset('images/favicon/apple-icon-152x152.png')}}">
        <link rel="apple-touch-icon" sizes="180x180" href="{{public_asset('images/favicon/apple-icon-180x180.png')}}">
        <link rel="icon" type="image/png" sizes="192x192"  href="{{public_asset('images/favicon/android-icon-192x192.png')}}">
        <link rel="icon" type="image/png" sizes="32x32" href="{{public_asset('images/favicon/favicon-32x32.png')}}">
        <link rel="icon" type="image/png" sizes="96x96" href="{{public_asset('images/favicon/favicon-96x96.png')}}">
        <link rel="icon" type="image/png" sizes="16x16" href="{{public_asset('images/favicon/favicon-16x16.png')}}">
        {{-- <link rel="manifest" href="{{public_asset('images/favicon/manifest.json')}}"> --}}
        <meta name="msapplication-TileColor" content="#ffffff">
        <meta name="msapplication-TileImage" content="{{public_asset('images/favicon/ms-icon-144x144.png')}}">
        <meta name="theme-color" content="#ffffff">
        <!-- Meta -->
        <meta name="description" content="@yield('meta_description', 'Default Description')">
        <meta name="author" content="@yield('meta_author', 'rawbinnn@gmail.com')">
        @yield('meta')

        <!-- Styles -->
        @yield('before-styles')
        {{ style(mix('css/theme.css')) }}
        {{ style(mix('css/styles.css')) }}
        {{ style('css/OverlayScrollbars.min.css') }}
        {{ style('vendor/rawbinn/media/assets/css/media.css') }}
        <link rel="stylesheet" href="https://code.ionicframework.com/ionicons/2.0.1/css/ionicons.min.css">
        <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-select/1.13.12/css/bootstrap-select.min.css" integrity="sha512-+c1xgQerYJcYrJmhc8o/6PW+DGVrmisTkjaUcW3zSCdziDgzQYOG+3vyMRuLEEjgQNJrf0463TFOXjwW+95j/w==" crossorigin="anonymous" referrerpolicy="no-referrer" />
        <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/summernote/0.8.18/summernote.min.css" integrity="sha512-KbfxGgOkkFXdpDCVkrlTYYNXbF2TwlCecJjq1gK5B+BYwVk7DGbpYi4d4+Vulz9h+1wgzJMWqnyHQ+RDAlp8Dw==" crossorigin="anonymous" referrerpolicy="no-referrer">
        <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/limonte-sweetalert2/11.3.10/sweetalert2.min.css" integrity="sha512-jtQXcnq6H9BVx+dOsdudNCZmNe2hBMqcPpnVgeZcV9L3615F4+QMQebbWW9TV2otOSk/kQgum0MpWefB3uL3pg==" crossorigin="anonymous" referrerpolicy="no-referrer" />
        <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/uppy/1.25.2/uppy.min.css" integrity="sha512-18rXWPU9+Yh7EtHplFw6or/QsCVpVZ0kO94b14AhUM90UySBTcrPrRQY+Epuax8nWb0EQvRiRvtvSr0CIN5suw==" crossorigin="anonymous">        
        <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-daterangepicker/3.0.5/daterangepicker.min.css" integrity="sha512-rBi1cGvEdd3NmSAQhPWId5Nd6QxE8To4ADjM2a6n0BrqQdisZ/RPUlm0YycDzvNL1HHAh1nKZqI0kSbif+5upQ==" crossorigin="anonymous" referrerpolicy="no-referrer" />
      
        @yield('after-styles')
        <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/tagify/3.22.1/tagify.min.css" integrity="sha512-91wa7heHLbuVdMrSXbWceVZva6iWDFlkFHnM+9Sc+oXFpTgw1FCqdnuaGBJfDVuNSNl0DwDmeGeJSORB0HyLZQ==" crossorigin="anonymous" />

        <!-- Html5 Shim and Respond.js IE8 support of Html5 elements and media queries -->
        <!-- WARNING: Respond.js doesn't work if you view the page via file:// -->
        <!--[if lt IE 9]>
        {{ Html::script('https://oss.maxcdn.com/libs/html5shiv/3.7.0/html5shiv.js') }}
        {{ Html::script('https://oss.maxcdn.com/libs/respond.js/1.3.0/respond.min.js') }}
        <![endif]-->

        <!-- Scripts -->
        <script>
            window.Laravel = <?php echo json_encode([
                'csrfToken' => csrf_token(),
            ]); ?>;
            var base_url = "{{URL::to('/')}}";
            var LARAPRESS = LARAPRESS || {};
            var MEDIA = MEDIA || {};
        </script>
        <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.6.0/jquery.min.js" integrity="sha512-894YE6QWD5I59HgZOGReFYm4dnWc1Qt5NtvYSaNcOP+u1T9qYdvdihz0PPSiiqn/+/3e7Jo4EaG7TubfWGUrMQ==" crossorigin="anonymous" referrerpolicy="no-referrer"></script>
    </head>
    <body class="{{ config('backend.layout') }} layout-fixed {{dynamic_admin_class()}}" id="{{dynamic_admin_class()}}">
        @include('includes.partials.logged-in-as')

        <div class="wrapper">
            @include('admin.includes.header')
            @include('admin.includes.sidebar')

            <!-- Content Wrapper. Contains page content -->
            <div class="content-wrapper">
                <!-- Content Header (Page header) -->
                <section class="content-header">
                    <div class="container-fluid">
                        <div class="row mb-2">
                        <div class="col-sm-6">
                            @yield('page-header')
                        </div><!-- /.col -->
                        <div class="col-sm-6">
                                {{-- Change to Breadcrumbs::render() if you want it to error to remind you to create the breadcrumbs for the given route --}}
                                <div class="float-sm-right">
                                    {!! Breadcrumbs::render() !!}
                                </div>
                        </div><!-- /.col -->
                        </div><!-- /.row -->
                    </div>

                </section>

                <!-- Main content -->
                <section class="content">
                    <div class="container-fluid">
                        <div class="loading-container"> <!--There's the container that centers it-->
					<div class="spinner-frame"> <!--The background-->
						<div class="spinner-bar"></div> <!--and The Spinny thing-->
					</div>
				</div>
                    @include('includes.partials.messages')
                    @yield('content')
                    </div>
                </section><!-- /.content -->
            </div><!-- /.content-wrapper -->

            @include('admin.includes.footer')
        </div><!-- ./wrapper -->

        <!-- JavaScripts -->        
        @stack('before-scripts')        
        <script src="https://cdnjs.cloudflare.com/ajax/libs/jqueryui/1.12.1/jquery-ui.min.js" integrity="sha512-uto9mlQzrs59VwILcLiRYeLKPPbS/bT71da/OEBYEwcdNUk8jYIy+D176RYoop1Da+f9mvkYrmj5MCLZWEtQuA==" crossorigin="anonymous" referrerpolicy="no-referrer"></script>
        <script src="https://cdnjs.cloudflare.com/ajax/libs/moment.js/2.29.3/moment.min.js"></script>
        <script src="https://cdnjs.cloudflare.com/ajax/libs/popper.js/1.11.0/umd/popper.min.js" integrity="sha384-b/U6ypiBEHpOf/4+1nzFpr53nxSS+GLCkfwBdFNTxtclqqenISfwAzpKaMNFNmj4" crossorigin="anonymous"></script>
        <script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap/4.6.1/js/bootstrap.min.js" integrity="sha512-UR25UO94eTnCVwjbXozyeVd6ZqpaAE9naiEUBK/A+QDbfSTQFhPGj5lOR6d8tsgbBk84Ggb5A3EkjsOgPRPcKA==" crossorigin="anonymous" referrerpolicy="no-referrer"></script>
        <script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-select/1.13.12/js/bootstrap-select.min.js" integrity="sha512-5gT89MavaXDOnRyVukHE371OCmfYauRM1mnsdmPHg+cnCyfBkm8yH7MTvTMEM/XRXfbIcNxnpbGTxaBzCRfTsw==" crossorigin="anonymous" referrerpolicy="no-referrer"></script>
        <script src="https://cdnjs.cloudflare.com/ajax/libs/limonte-sweetalert2/11.3.10/sweetalert2.min.js" integrity="sha512-LwESE8nE3vcnoUWmYo6skVQ+BRT5UhqnPweGro7e22RSDLVwftCfFIPt+Ha2tm1Gg7RXvYp/jPyih3DUB06PwA==" crossorigin="anonymous" referrerpolicy="no-referrer"></script>
        

        <!-- Resolve conflict in jQuery UI tooltip with Bootstrap tooltip -->
        <script>
            $.widget.bridge('uibutton', $.ui.button)
        </script>
        {{ script('vendor/admin-lte/dist/js/adminlte.min.js') }}
        <script src="https://cdnjs.cloudflare.com/ajax/libs/summernote/0.8.18/summernote-bs4.min.js" integrity="sha512-+cXPhsJzyjNGFm5zE+KPEX4Vr/1AbqCUuzAS8Cy5AfLEWm9+UI9OySleqLiSQOQ5Oa2UrzaeAOijhvV/M4apyQ==" crossorigin="anonymous" referrerpolicy="no-referrer"></script>
        <script src="https://cdnjs.cloudflare.com/ajax/libs/tagify/4.8.1/jQuery.tagify.min.js" integrity="sha512-kvTsuvtttw2Pi+3vRqQskiwIKMyQu2CEBVWFvoVZWBj7Y4GLloLrL9Pg2tHgehBgZzjxgIcNLL3lfOjMZ9sA1w==" crossorigin="anonymous" referrerpolicy="no-referrer"></script>
        <script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-daterangepicker/3.0.5/daterangepicker.min.js" integrity="sha512-mh+AjlD3nxImTUGisMpHXW03gE6F4WdQyvuFRkjecwuWLwD2yCijw4tKA3NsEFpA1C3neiKhGXPSIGSfCYPMlQ==" crossorigin="anonymous" referrerpolicy="no-referrer"></script>
        {{ script('js/custom.js') }}
        {{ script('js/larapress.js') }}
        <script src="https://cdnjs.cloudflare.com/ajax/libs/uppy/1.25.0/uppy.min.js" integrity="sha512-p3CLwEs/Vf1sakIx/MBh9vxACIWLwsJFPTI+PkZoH/fddS8iP3lPRgLGL4/P8WGdz5ZJWu8ZzWMWCUTxJtOVxQ==" crossorigin="anonymous"></script>
        
        <script>
            function uploadImageContent(image, editor, imageUploaderUrl, imageGroup) {
                var data = new FormData();
                data.append("image", image);
                data.append("group", imageGroup);
                $.ajax({
                    url: imageUploaderUrl,
                    cache: false,
                    contentType: false,
                    processData: false,
                    data: data,
                    type: "POST",
                    success: function(data) {
                        var url = '';
                        if (data.thumbnail_url == '') {
                            url = data.original_url;
                        } else {
                            url = data.thumbnail_url;
                        }
                        var image = $('<img>').attr('src', url);
                        $(editor).summernote("insertNode", image[0]);
                    },
                    error: function(data) {
                        console.log(data);
                    }
                });
            }    
        </script>
        {{ script('vendor/rawbinn/media/assets/js/media.js') }}
        <script>
            function loading(status = true) {
                status ? $('.loading-container').show() : $('.loading-container').hide();
            }
        </script>
        
        @stack('after-scripts')
    </body>
</html>
