@extends ('admin.layouts.app')

@section ('title', 'Gallery Management | Edit Gallery Item')

@section('page-header')
    <h1>
        Gallery Management
        <small>Edit Gallery Item</small>
    </h1>
@endsection

@section('content')
    {{ Form::model($gallery, ['route' => ['admin.gallery.item.update', $gallery->id], 'role' => 'form', 'method' => 'put']) }}

        <div class="card">
            <div class="card-header with-border">
                <h3 class="card-title">Edit Gallery Item</h3>

                <div class="card-tools float-right">
                    <!-- Include your header buttons -->
                </div><!--card-tools float-right-->
            </div><!-- /.card-header -->

            <div class="card-body">
                <div class="form-group">
                    {{ Form::label('title', 'Title') }}
                    {{ Form::text('title', null, ['class' => 'form-control', 'placeholder' => 'Gallery Title']) }}
                </div><!--form group-->

                <div class="form-group">
                    <label for="description">Description</label>
                    <textarea class="seshra-text-editor" name="description" data-min-height="300"
                        data-image-submit-url="{{ route('admin.image.upload') }}" data-format="true"
                        data-image-group="blogs">{!! $gallery->description !!}</textarea>
                </div>

                <div class="form-group">
                    <label for="site-logo">Gallery Image</label>
                    <div class="input-group" data-toggle="seshra-uploader" data-type="image" data-group="gallery">
                        <div class="input-group-prepend">
                            <div class="input-group-text bg-soft-secondary font-weight-medium">Browse</div>
                        </div>
                        <div class="form-control file-amount">Choose File</div>
                        <input type="hidden" name="media_id" class="selected-files" value="{{$gallery->image_id}}">
                    </div>
                    <div class="file-preview box sm">
                    </div>
                </div><!--form group-->
            </div><!-- /.card-body -->
        </div><!--box-->

        <div class="card">
            <div class="card-body">
                <div class="float-left">
                    {{ link_to_route('admin.gallery.index', trans('buttons.general.cancel'), [], ['class' => 'btn btn-danger btn-xs']) }}
                </div><!--float-left-->

                <div class="float-right">
                    {{ Form::submit(trans('buttons.general.crud.update'), ['class' => 'btn btn-success btn-xs']) }}
                </div><!--float-right-->

                <div class="clearfix"></div>
            </div><!-- /.card-body -->
        </div><!--box-->

    {{ Form::close() }}
@stop

@push('after-scripts')
{{  script('vendor/ckeditor/ckeditor.js') }}
{{ script('vendor/laravel-filemanager/js/stand-alone-button.js')}}
<script>
 $(function () {
           // instance, using default configuration.
            CKEDITOR.replace('c7678', {
                filebrowserImageBrowseUrl: base_url+'/admin/filemanager?type=Images'
            });
            var url = base_url + '/admin/filemanager';
            $('#featuredImage').filemanager('image',{prefix: url});
        });

</script>
@endpush
