@extends ('admin.layouts.app')

@section ('title', 'Gallery Management | Create Gallery Item')

@section('page-header')
    <h1>
        Gallery Management
        <small>Add Gallery Image</small>
    </h1>
@endsection

@section('content')
    {{ Form::open(['route' => ['admin.gallery.item.store', $gallery->id], 'role' => 'form', 'method' => 'post']) }}

        <div class="card">
            <div class="card-header with-border">
                <h3 class="card-title">Add Items in Gallery</h3>

                <div class="card-tools float-right">
                    <!-- Include your header buttons -->
                </div><!--card-tools float-right-->
            </div><!-- /.card-header -->

            <div class="card-body">
                <div class="form-group">
                    {{ Form::label('title', 'Title') }}
                    {{ Form::text('title', null, ['class' => 'form-control', 'placeholder' => 'Gallery Item Title']) }}
                </div><!--form group-->

                {{-- <div class="form-group">
                    <label for="content">Description</label>
                    {{ Form::textarea('description', null, ['id' => 'c7678']) }}
                </div> --}}
                <div class="form-group">
                    <label for="description">Description</label>
                    <textarea class="seshra-text-editor" name="description" data-min-height="300"
                        data-image-submit-url="{{ route('admin.image.upload') }}" data-format="true"
                        data-image-group="blogs">{!! old('description') !!}</textarea>
                </div>

                <div class="form-group">
                    <label for="site-logo">Gallery Image</label>
                    <div class="input-group" data-toggle="seshra-uploader" data-type="image" data-group="gallery">
                        <div class="input-group-prepend">
                            <div class="input-group-text bg-soft-secondary font-weight-medium">Browse</div>
                        </div>
                        <div class="form-control file-amount">Choose File</div>
                        <input type="hidden" name="media_id" class="selected-files">
                    </div>
                    <div class="file-preview box sm">
                    </div>
                </div><!--form group-->
            </div><!-- /.card-body -->
        </div><!--box-->

        <div class="card">
            <div class="card-body">
                <div class="float-left">
                    {{ link_to_route('admin.gallery.index', trans('buttons.general.cancel'), [], ['class' => 'btn btn-danger btn-xs']) }}
                </div><!--float-left-->

                <div class="float-right">
                    {{ Form::submit(trans('buttons.general.crud.create'), ['class' => 'btn btn-success btn-xs']) }}
                </div><!--float-right-->

                <div class="clearfix"></div>
            </div><!-- /.card-body -->
        </div><!--box-->

    {{ Form::close() }}
@stop

@push('after-scripts')

@endpush
