<div class="card" id="{{$name}}{{$col}}{{$item}}">
    <div class="card-header with-border">
        <h3 class="card-title">Title & Subtitle Block</h3>
        <div class="card-tools float-right">
            @isset($page)
                <button type="button" class="btn btn-xs btn-danger delete-meta-item" data-pid="{{$page->id}}" data-col="{{$col}}" data-item="{{$item}}" data-key="{{ Str::slug(strtolower($name)) }}"><i class="fa fa-trash"></i></button>
            @else
                <button type="button" class="btn btn-xs btn-danger delete-meta-item" data-col="{{$col}}" data-item="{{$item}}" data-key="{{ Str::slug(strtolower($name)) }}"><i class="fa fa-trash"></i></button>
            @endisset
        </div>
    </div>

    <div class="card-body">
        <input type="hidden" name="post_meta[{{ Str::slug(strtolower($name)) }}][{{$col}}][{{$item}}][type]" value="title_subtitle_block">
        <div class="form-group row">
            <label for="content" class="col-md-2">Title</label>
            <div class="col-md-10">
                <input type="text" class="form-control" name="post_meta[{{ Str::slug(strtolower($name)) }}][{{$col}}][{{$item}}][title]" value="{{$post['title'] ?? ''}}">
            </div>
        </div>
        <div class="form-group row">
            <label for="content" class="col-md-2">Subtitle</label>
            <div class="col-md-10">
                <input type="text" class="form-control" name="post_meta[{{ Str::slug(strtolower($name)) }}][{{$col}}][{{$item}}][subtitle]" value="{{$post['subtitle'] ?? ''}}">
            </div>
        </div>
        <div class="form-group row">
            <label for="content" class="col-md-2">Title Subtitle Align</label>
            <div class="col-md-10">
                <select class="form-control" name="post_meta[{{ Str::slug(strtolower($name)) }}][{{$col}}][{{$item}}][align]">
                    <option value="left" {{ (isset($post['align']) && $post['align'] == 'left') ? 'selected' : ''}}>Left</option>
                    <option value="center" {{ (isset($post['align']) && $post['align'] == 'center') ? 'selected' : ''}}>Center</option>
                    <option value="right" {{ (isset($post['align']) && $post['align'] == 'right') ? 'selected' : ''}}>Right</option>
                </select>
            </div>
        </div>
    </div>
</div>