<div class="card">
    <div class="card-header with-border">
        <h3 class="card-title">{{ ucfirst($name) }}</h3>
        <div class="card-tools float-right">
            @isset($page)
                #{{ $meta->sort }}
                <button type="button" class="btn btn-xs btn-secondary sort-meta-item" data-key="{{$name}}" data-pid="{{$page->id}}" data-sort="up" data-toggle="tooltip" data-placement="top" title="Move block up"><i class="fas fa-arrow-up"></i></button>
                <button type="button" class="btn btn-xs btn-secondary sort-meta-item" data-key="{{$name}}" data-pid="{{$page->id}}" data-sort="down" data-toggle="tooltip" data-placement="top" title="Move block down"><i class="fas fa-arrow-down"></i></button>
                <button type="button" class="btn btn-xs btn-primary edit-meta-item" data-name="{{ ucfirst(str_replace('-', ' ', $name)) }}" data-key="{{$name}}" data-pid="{{$page->id}}" data-cols="{{$cols ?? ''}}" data-class="{{$class ?? ''}}" data-id="{{$id ?? ''}}">Edit</button>
                <button type="button" class="btn btn-xs btn-danger delete-meta-item" data-key="{{$name}}" data-pid="{{$page->id}}">Delete</button>
            @else
                <button type="button" class="btn btn-xs btn-danger delete-meta-item" data-key="{{ Str::slug(strtolower($name)) }}">Delete</button>
            @endisset
        </div>
    </div>

    <div class="card-body">
        <input type="hidden" name="post_meta[{{ Str::slug(strtolower($name)) }}][type]" value="text_list_block">
        <input type="hidden" name="post_meta[{{ Str::slug(strtolower($name)) }}][id]" value="{{ $id ?? '' }}">
        <input type="hidden" name="post_meta[{{ Str::slug(strtolower($name)) }}][class]" value="{{ $class ?? '' }}">
        <input type="hidden" name="post_meta[{{ Str::slug(strtolower($name)) }}][cols]" value="{{ $cols ?? '' }}">
        <div class="form-group">
            <div class="list-item-{{ Str::slug(strtolower($name ?? '')) }}">
                <label for="List">Item</label>
                @isset($list)
                    @foreach ($list as $item)
                        <div class="row mb-2 meta-item-card">
                            <div class="col-md-6">
                                <input type="text" name="post_meta[{{ Str::slug(strtolower($name)) }}][key][]" value="{{$item['key']}}"
                                    placeholder="key" class="form-control">
                            </div>
                            <div class="col-md-6">
                                <textarea name="post_meta[{{ Str::slug(strtolower($name)) }}][value][]" rows="2" placeholder="value" class="form-control">{!! $item['value'] !!}</textarea>
                            </div>
                            <div class="meta-item-remove">
                                <button class="btn btn-sm btn-link meta-item-remove-btn" data-toggle="remove-parent" data-parent=".meta-item-card" type="button">
                                    <i class="fas fa-times"></i>
                                </button>
                            </div>
                        </div>
                    @endforeach
                @else
                    <div class="row mb-2 meta-item-card">
                        <div class="col-md-6">
                            <input type="text" name="post_meta[{{ Str::slug(strtolower($name)) }}][key][]" value=""
                                placeholder="key" class="form-control">
                        </div>
                        <div class="col-md-6">
                            <textarea name="post_meta[{{ Str::slug(strtolower($name)) }}][value][]" rows="2" placeholder="value" class="form-control"></textarea>
                        </div>
                        <div class="meta-item-remove">
                            <button class="btn btn-sm btn-link meta-item-remove-btn" data-toggle="remove-parent" data-parent=".meta-item-card" type="button">
                                <i class="fas fa-times"></i>
                            </button>
                        </div>
                    </div>
                @endisset
            </div>
        </div>

        <button type="button" class="btn btn-primary btn-sm float-right add-more" data-toggle="list-item-add-more"
            data-target=".list-item-{{ Str::slug(strtolower($name ?? '')) }}" data-name="{{ Str::slug(strtolower($name ?? '')) }}">
            Add New
        </button>
    </div>
    <script>
        $('[data-toggle="list-item-add-more"]').each(function() {
            var $this = $(this);
            var name = $this.data('name');
            $this.on("click", function(e) {
                e.preventDefault();
                var content =
                    '<div class="row mb-2 meta-item-card"><div class="col-md-6"><input type="text" name="post_meta['+name+'][key][]" value="" placeholder="key" class="form-control"></div><div class="col-md-6"><textarea name="post_meta['+name+'][value][]" rows="2" placeholder="value" class="form-control"></textarea></div><div class="meta-item-remove"><button class="btn btn-sm btn-link meta-item-remove-btn" data-toggle="remove-parent" data-parent=".meta-item-card" type="button"><i class="fas fa-times"></i></button></div></div>';
                var target = $this.data("target");
                $(target).append(content);
            });
        });
    </script>
</div>
