<div class="card" id="{{$name}}{{$col}}{{$item}}">
    <div class="card-header with-border">
        <h3 class="card-title">List Block</h3>
        <div class="card-tools float-right">
            @isset($page)
                <button type="button" class="btn btn-xs btn-danger delete-meta-item" data-pid="{{$page->id}}" data-col="{{$col}}" data-item="{{$item}}" data-key="{{ Str::slug(strtolower($name)) }}"><i class="fa fa-trash"></i></button>
            @else
                <button type="button" class="btn btn-xs btn-danger delete-meta-item" data-col="{{$col}}" data-item="{{$item}}" data-key="{{ Str::slug(strtolower($name)) }}"><i class="fa fa-trash"></i></button>
            @endisset
        </div>
    </div>
    <div class="card-body">
        <input type="hidden" name="post_meta[{{ Str::slug(strtolower($name)) }}][{{$col}}][{{$item}}][type]" value="list_block">
        <div class="form-group">
            <div class="list-item-{{ Str::slug(strtolower($name ?? '')) }}">
                <label for="List">Item</label>
                @isset($post['content'])
                    @foreach ($post['content'] as $p)
                        <div class="row mb-2 meta-item-card">
                            <div class="col-md-12">
                                <input type="text" name="post_meta[{{ Str::slug(strtolower($name)) }}][{{$col}}][{{$item}}][content][]" value="{{$p}}"
                                    placeholder="Content" class="form-control">
                            </div>
                            <div class="meta-item-remove">
                                <button class="btn btn-sm btn-link meta-item-remove-btn" data-toggle="remove-parent" data-parent=".meta-item-card" type="button">
                                    <i class="fas fa-times"></i>
                                </button>
                            </div>
                        </div>
                    @endforeach
                @else
                    <div class="row mb-2 meta-item-card">
                        <div class="col-md-12">
                            <input type="text" name="post_meta[{{ Str::slug(strtolower($name)) }}][{{$col}}][{{$item}}][content][]" value=""
                                placeholder="Content" class="form-control">
                        </div>
                        <div class="meta-item-remove">
                            <button class="btn btn-sm btn-link meta-item-remove-btn" data-toggle="remove-parent" data-parent=".meta-item-card" type="button">
                                <i class="fas fa-times"></i>
                            </button>
                        </div>
                    </div>
                @endisset
            </div>
        </div>

        <button type="button" class="btn btn-primary btn-sm float-right add-more" data-toggle="list-item-add-more"
            data-target=".list-item-{{ Str::slug(strtolower($name ?? '')) }}" data-name="{{ Str::slug(strtolower($name ?? '')) }}" data-col="{{$col}}" data-item="{{$item}}">
            Add New
        </button>
    </div>
    <script>
        $('[data-toggle="list-item-add-more"]').each(function() {
            var $this = $(this);
            var name = $this.data('name');
            var col = $this.data('col');
            var item = $this.data('item');
            $this.on("click", function(e) {
                e.preventDefault();
                var content =
                    '<div class="row mb-2 meta-item-card"><div class="col-md-12"><input type="text" name="post_meta['+name+']['+col+']['+item+'][content][]" value="" placeholder="Content" class="form-control"></div><div class="meta-item-remove"><button class="btn btn-sm btn-link meta-item-remove-btn" data-toggle="remove-parent" data-parent=".meta-item-card" type="button"><i class="fas fa-times"></i></button></div></div>';
                var target = $this.data("target");
                $(target).append(content);
            });
        });
    </script>
</div>
