@extends ('admin.layouts.app')

@section ('title',$labels['name'] ?? $label)

@section('page-header')
    <h1>
        {{$label ?? 'Item'}}
        <small>Edit {{$label}}</small>
    </h1>
@endsection

@section('after-styles')

@endsection

@section('content')
    {{ Form::model($page, ['route' => ['admin.custom.post.type.update', $post_type, $page->id], 'role' => 'form', 'method' => 'put']) }}
    <input name="lang" type="hidden" value="{{$lang}}">
    <div class="row">
        <div class="col-md-8">
            <ul class="nav nav-tabs nav-fill border-light">
                @foreach (locales() as $locale)
  					<li class="nav-item">
  						<a class="nav-link text-reset @if ($locale == $lang ) active @else bg-soft-dark border-light border-left-0 @endif py-3" href="{{ route('admin.custom.post.type.edit', [$post_type, $page->id]) }}?lang={{$locale}}">
  							<img src="{{ public_asset('images/flags/'.$locale.'.png') }}" height="11" class="mr-1">
  							<span>{{$locale}}</span>
  						</a>
  					</li>
  		        @endforeach
            </ul>
            <div class="card">
                <div class="card-header with-border">
                    <h3 class="card-title">Edit {{$labels['name'] ?? $label}}</h3>
                    <div class="card-tools float-right">
                        <a href="{{route('admin.custom.post.type.create',$post_type)}}" class="btn btn-success btn-xs float-right">{{$labels['add_new'] ?? 'Add New Item'}}</a>
                    </div><!--card-tools float-right-->
                    
                </div><!-- /.card-header -->

                <div class="card-body">
                    @if( array_key_exists('title', $supports))
                    <div class="form-group">
                        {{ Form::label('title', $supports['title']) }}
                        <input type="text" class="form-control" name="{{$lang}}[title]" value="{{$page->translate($lang)->title ?? $page->title}}" placeholder="{{$supports['title']}}">
                    </div>
                    @endif
                    @if( array_key_exists('subtitle', $supports))
                    <div class="form-group">
                        {{ Form::label('subtitle', $supports['subtitle']) }}
                        <textarea name="{{$lang}}[subsubtitle]" class="form-control seshra-text-editor" data-airmode="true" placeholder="{{$supports['subtitle']}}">{!! $page->translate($lang)->subtitle ?? $page->subtitle !!}</textarea>
                        
                    </div>
                    @endif
                    @if( array_key_exists('title', $supports))
                    <div class="form-group">
                        {{ Form::label('slug', trans('validation.attributes.backend.page.slug')) }}
                        {{ Form::text('slug', null, ['class' => 'form-control','placeholder' => trans('validation.attributes.backend.page.slug')]) }}
                    </div>
                    @endif
                    @if( array_key_exists('editor', $supports))
                    <div class="form-group">
                        <label for="content">{{$supports['editor']}}</label>
                        <textarea name="{{$lang}}[content]" class="seshra-text-editor" data-min-height="300" data-image-submit-url="{{ route('admin.image.upload') }}" data-format="true" data-image-group="blogs">{!! $page->translate($lang)->content ?? $page->content !!}</textarea>
                    </div>
                    @endif
                    <div class="form-group">
                        <label for="meta-title" class="meta-title">Meta Title <small>(Recommended less than 60 characters) <span id="meta_title_length" class="{{ strlen($page->meta_title) < 61 ? 'green' : 'red' }}">{{ strlen($page->meta_title) }} characters</span></small></label>
                        {{ Form::text('meta_title', null, ['class' => 'form-control','placeholder' => 'Meta Title','id' => 'meta-title']) }}
                    </div>
                    <div class="form-group">
                        <label for="meta-description" class="meta-description">Meta Description <small>(Recommended less than 160 characters) <span  id="meta_description_length" class="{{ strlen($page->meta_description) < 161 ? 'green' : 'red' }}">{{ strlen($page->meta_description) }} characters</span></small></label>
                        {{ Form::textarea('meta_description', null, ['class' => 'form-control','rows' => '4','id' => 'meta-description']) }}
                    </div>
                </div>
            </div>
            
        </div>
        <div class="col-md-4">
            @if( array_key_exists('category', $supports))
            <div class="card">
                <div class="card-header with-border">
                    <h3 class="card-title">{{$supports['category']}}</h3>
                </div><!-- /.card-header -->
                <div class="card-body">
                    <div class="form-group">
                        <div id="selectCategory">
                            <ul>
                                @include('admin.custom_post.categories',['categories' => $categories])
                            </ul>
                        </div>
                    </div>
                </div>
                <!--form control-->
            </div>
            @endif
            @if( array_key_exists('thumbnail', $supports))
            <div class="card">
                <div class="card-header with-border">
                    <h3 class="card-title">{{$supports['thumbnail']}}</h3>
                </div><!-- /.card-header -->
                <div class="card-body">
                    <div class="form-group">
                        <div class="input-group" data-toggle="seshra-uploader" data-type="image" data-group="blogs">
                            <div class="input-group-prepend">
                                <div class="input-group-text bg-soft-secondary font-weight-medium">Browse</div>
                            </div>
                            <div class="form-control file-amount">Choose File</div>
                            <input type="hidden" name="featured_image" value="{{ $page->media_id }}" class="selected-files">
                        </div>
                        <div class="file-preview box sm">
                        </div>
                    </div>
                </div><!-- /.card-body -->
            </div>
            @endif
            <div class="card position-sticky" style="top: 30px">
                <div class="card-body">
                    <div class="form-group">
                        {{ Form::submit(trans('buttons.general.crud.update'), ['class' => 'btn btn-success btn-md']) }}
                    </div>
                </div>
                <!--form control-->
            </div>
            <!--card-->
        </div>
    </div>
    {{ Form::close() }}


@stop
@push('after-scripts')
    <script>
        $(function() {
            var type;
          

            $(document).on('click', '#saveEdit', function(e) {
                $("<input>").attr({
                    name: "saveEdit",
                    id: "savenedit",
                    type: "hidden",
                    value: 'saveEdit'
                }).appendTo("#postForm");

                $('#postForm').submit();
            });

            $('#meta-title').on('keyup', function() {
                var length = $(this).val().length;
                if (length > 60) {
                    $('#meta_title_length').addClass('red');
                    $('#meta_title_length').removeClass('green');
                } else {
                    $('#meta_title_length').removeClass('red');
                    $('#meta_title_length').addClass('green');
                }
                $('#meta_title_length').html(length + ' characters');
            });

            $('#meta-description').on('keyup', function() {
                var length = $(this).val().length;
                if (length > 160) {
                    $('#meta_description_length').addClass('red');
                    $('#meta_description_length').removeClass('green');
                } else {
                    $('#meta_description_length').removeClass('red')
                    $('#meta_description_length').addClass('green');;
                }
                $('#meta_description_length').html(length + ' characters');
            });
        });
    </script>
@endpush
