@extends ('admin.layouts.app')

@section ('title',$labels['name'] ?? $label)

@section('page-header')
    <h1>
        {{$label ?? 'Item'}}
        <small>Deleted {{$label}}</small>
    </h1>
@endsection
@section('after-styles')
  {{ style('vendor/datatables-bs4/css/dataTables.bootstrap4.min.css') }}
  {{ style('vendor/datatables-responsive/css/responsive.bootstrap4.min.css') }}
@stop

@section('content')
    <div class="card">
        <div class="card-header with-border">
            <h3 class="card-title">Deleted {{ucfirst($post_type)}}</h3>

            <div class="card-tools float-right">
               <button type="button" id="delete_button" class="btn btn-xs btn-danger" style="display:none;">Delete</button>
                <a href="{{route('admin.custom.post.type', $post_type)}}" class="btn btn-success btn-xs">Back</a>
            </div>
        </div>

        <div class="card-body">
            <div class="table-responsive">
                <table id="pages-table" class="table table-condensed table-hover">
                    <thead>
                    <tr>
                    <th><input type="checkbox" name="select_all" id="select_all"></th>
                        <th>{{ trans('labels.backend.table.id') }}</th>
                        <th>{{ trans('labels.backend.table.title') }}</th>
                        <th>Author</th>
                        <th>{{ trans('labels.backend.table.created') }}</th>
                        <th>{{ trans('labels.backend.table.last_updated') }}</th>
                        <th>{{ trans('labels.general.actions') }}</th>
                    </tr>
                    </thead>
                </table>
            </div><!--table-responsive-->
        </div><!-- /.card-body -->
    </div><!--box-->

@stop

@push('after-scripts')
    <!-- DataTables -->
    {{ script('vendor/datatables/jquery.dataTables.min.js') }}
    {{ script('vendor/datatables-bs4/js/dataTables.bootstrap4.min.js') }}
    <script>
        $(function() {
            var table = $('#pages-table').DataTable({
                processing: true,
                serverSide: true,
                ajax: {
                    url: '{{ route("admin.custom.post.type.datatable", $post_type) }}',
                    type: 'post',
                    data: {trashed: true, _token: Laravel.csrfToken}
                },
                columns: [
                    {data: 'select', name: 'select', searchable: false, sortable: false},
                    {data: 'id', name: 'id'},
                    {data: 'title', name: 'title'},
                    {data: 'author', name: 'author', searchable: false, sortable: false},
                    {data: 'created_at', name: 'created_at'},
                    {data: 'updated_at', name: 'updated_at'},
                    {data: 'actions', name: 'actions', searchable: false, sortable: false}
                ],
                order: [[1, "asc"]],
                searchDelay: 500
            });

            $("body").on("click", "a[name='delete_page_perm']", function(e) {
                e.preventDefault();
                var linkURL = $(this).attr("href");

                Swal.fire({
                    title: "{{ trans('strings.backend.general.are_you_sure') }}",
                    text: "{{ trans('strings.backend.general.delete_confirm',['attribute'=>'page']) }}",
                    icon: "warning",
                    showCancelButton: true,
                    confirmButtonColor: "#DD6B55",
                    confirmButtonText: "{{ trans('strings.backend.general.continue') }}",
                    cancelButtonText: "{{ trans('buttons.general.cancel') }}",
                }).then((result) => {
                    result.value && window.location.assign(linkURL);
                });
            });

            $("body").on("click", "a[name='restore_page']", function(e) {
                e.preventDefault();
                var linkURL = $(this).attr("href");

                Swal.fire({
                    title: "{{ trans('strings.backend.general.are_you_sure') }}",
                    text: "{{ trans('strings.backend.general.restore_confirm',['attribute'=>'page']) }}",
                    type: "warning",
                    showCancelButton: true,
                    confirmButtonColor: "#DD6B55",
                    confirmButtonText: "{{ trans('strings.backend.general.continue') }}",
                    cancelButtonText: "{{ trans('buttons.general.cancel') }}",
                }).then((result) => {
                    result.value && window.location.assign(linkURL);
                });
            });

             // Handle click on "Select all" control
            $('#select_all').on('click', function(){
                // Get all rows with search applied
                var rows = table.rows({ 'search': 'applied' }).nodes();
                // Check/uncheck checkboxes for all rows in the table
                $('input[type="checkbox"]', rows).prop('checked', this.checked);
                if(!this.checked){
                    $('#delete_button').hide();
                    $('#selected_data div').html('');
                }else{
                    $('#delete_button').show();
                }
            });

            // Handle click on checkbox to set state of "Select all" control
            $('#pages-table tbody').on('change', 'input[type="checkbox"]', function(){
                // If checkbox is not checked
                if(!this.checked){
                    var el = $('#select_all').get(0);
                    // If "Select all" control is checked and has 'indeterminate' property
                    if(el && el.checked && ('indeterminate' in el)){
                        // Set visual state of "Select all" control
                        // as 'indeterminate'
                        el.indeterminate = true;
                    }
                    
                }
                $('#delete_button').show();
            });

            // Handle form submission event
            $('#delete_button').on('click', function(e) {
                   
                Swal.fire({
                    title: "{{ trans('strings.backend.general.are_you_sure') }}",
                    text: "{{ trans('strings.backend.general.delete_confirm',['attribute'=>'page']) }}",
                    icon: "warning",
                    showCancelButton: true,
                    confirmButtonColor: "#DD6B55",
                    confirmButtonText: "{{ trans('strings.backend.general.continue') }}",
                    cancelButtonText: "{{ trans('buttons.general.cancel') }}",
                }).then((result) => {
                    if(result.value){
                        $.ajax({
                            url: "{{route('admin.custom.post.type.deleteSelected', $post_type)}}",
                            type: 'post',
                            dataType: 'json',
                            data: table.$('input[type="checkbox"]').serialize(),
                            success: function(data) {
                                if(data.status)
                                    table.ajax.reload();
                            }
                        });
                    }
                });
               
            });
        });
    </script>
@endpush
