@extends ('admin.layouts.app')

@section ('title', trans('labels.backend.comment.management'))

@section('after-styles')
        <!-- DataTables -->
  {{ style('vendor/datatables-bs4/css/dataTables.bootstrap4.min.css') }}
  {{ style('vendor/datatables-responsive/css/responsive.bootstrap4.min.css') }}
@stop

@section('page-header')
    <h1>
        {{ trans('labels.backend.comment.management') }}
        <small>{{ trans('labels.backend.comment.active') }}</small>
    </h1>
@endsection

@section('content')
    <div class="card">
        <div class="card-header with-border">
            <h3 class="card-title">{{ trans('labels.backend.comment.active') }}</h3>

            <div class="card-tools float-right">
                <!-- Include your header buttons  -->
                    <button type="button" id="delete_button" class="btn btn-xs btn-danger" style="display:none;" onclick="return confirm('Are you sure want to delete this comment?');">Delete</button>
                    {{ link_to_route('admin.comments.deleted', trans('menus.backend.comments.deleted'), [], ['class' => 'btn btn-danger btn-xs']) }}
            </div><!--card-tools float-right-->
        </div><!-- /.card-header -->

        <div class="card-body">
            <div class="table-responsive">
                <table id="comments-table" class="table table-condensed table-hover">
                    <thead>
                    <tr>
                        <th>{{ trans('labels.backend.table.id') }}</th>
                        <th>{{ trans('labels.backend.comment.comments') }}</th>
                        <th>{{ trans('labels.backend.table.status') }}</th>
                        <th>{{ trans('labels.backend.table.created') }}</th>
                        <th>{{ trans('labels.general.actions') }}</th>
                    </tr>
                    </thead>
                </table>
            </div><!--table-responsive-->
        </div><!-- /.card-body -->
    </div><!--box-->

@stop

@push('after-scripts')
<!-- DataTables -->
    {{ script('vendor/datatables/jquery.dataTables.min.js') }}
    {{ script('vendor/datatables-bs4/js/dataTables.bootstrap4.min.js') }}

    <script>
        $(function() {
                $('#comments-table').DataTable({
                    processing: true,
                    serverSide: true,
                    iDisplayLength: 25,
                    ajax: {
                        url: '{{ route("admin.comments.get") }}',
                        type: 'post',
                        data: {trashed: false, _token: Laravel.csrfToken}
                    },
                    columns: [
                        {data: 'id', name: 'id'},
                        {data: 'comment', name: 'comment', sortable: false},
                        {data: 'status', name: 'status', searchable: false, },
                        {data: 'created_at', name: 'created_at'},
                        {data: 'actions', name: 'actions', searchable: false, sortable: false}
                    ],
                    order: [[0, "asc"]],
                    searchDelay: 500
                });
            
        });
    </script>
@endpush
