@extends ('admin.layouts.app')

@section ('title', trans('labels.backend.blog.edit'))

@section('page-header')
    <h1>
        {{ trans('labels.backend.blog.management') }}
        <small>{{ trans('labels.backend.blog.edit') }}</small>
    </h1>
@endsection

@section('after-styles')

@endsection

@section('content')
<div class="admin-post">
    {{ Form::model($post,['route' => ['admin.blog.update', $post->id], 'role' => 'form', 'method' => 'put']) }}
    <input name="lang" type="hidden" value="{{$lang}}">
    <div class="row">
    <div class="col-md-8">
        <ul class="nav nav-tabs nav-fill border-light">
            @foreach (locales() as $locale)
                  <li class="nav-item">
                      <a class="nav-link text-reset @if ($locale == $lang ) active @else bg-soft-dark border-light border-left-0 @endif py-3" href="{{ route('admin.blog.edit', $post->id) }}?lang={{$locale}}">
                          <img src="{{ public_asset('images/flags/'.$locale.'.png') }}" height="11" class="mr-1">
                          <span>{{$locale}}</span>
                      </a>
                  </li>
              @endforeach
        </ul>
        <div class="card">
            <div class="card-header with-border">
                <h3 class="card-title">{{ trans('labels.backend.blog.edit') }}</h3>

                <div class="card-tools float-right">
                    {{ link_to_route('admin.blog.create', trans('menus.backend.blog.create'), [], ['class' => 'btn btn-success btn-xs']) }}
                </div>
            </div><!-- /.card-header -->

            <div class="card-body">
                <div class="form-group">
                    {{ Form::label('title', trans('validation.attributes.backend.blog.title')) }}
                    <input type="text" class="form-control" name="{{$lang}}[title]" value="{{$post->translate($lang)->title ?? $post->title}}" placeholder="{{trans('validation.attributes.backend.blog.title')}}">
                </div><!--form control-->

                <div class="form-group">
                    {{ Form::label('slug', trans('validation.attributes.backend.blog.slug')) }}
                    {{ Form::text('slug', null, ['class' => 'form-control', 'placeholder' => trans('validation.attributes.backend.blog.slug')]) }}
                </div><!--form control-->

                <div class="form-group">
                    <label for="content">Content</label>
                    <textarea class="seshra-text-editor" name="{{$lang}}[content]" data-min-height="300" data-image-submit-url="{{ route('admin.image.upload') }}" data-format="true" data-image-group="blogs">{!! $post->translate($lang)->content ?? '' !!}</textarea>
                </div>

                @template('larapress.blog.input')

            </div>
        </div>
        @template('larapress.blog.card')
        <div class="card">
            <div class="card-header with-border">
                <h3 class="card-title">Seo Information</h3>
            </div><!-- /.card-header -->

            <div class="card-body">
                 <div class="form-group">
                    <label for="meta-title" class="meta-title" >Meta Title <small>(Recommended less than 60 characters) <span id="meta_title_length" class="{{strlen($post->meta_title)< 61 ? 'green': 'red'}}">{{strlen($post->meta_title)}} characters</span></small></label>
                    {{ Form::text('meta_title', null, ['class' => 'form-control', 'placeholder' =>'Meta Title', 'id' =>  'meta-title']) }}
                </div><!--form group-->

                <div class="form-group">
                    <label for="meta-description" class="meta-description">Meta Description <small>(Recommended less than 160 characters) <span id="meta_description_length" class="{{strlen($post->meta_description)< 161 ? 'green': 'red'}}">{{strlen($post->meta_description)}} characters</span></small></label>
                    {{ Form::textarea('meta_description', null, ['class' => 'form-control', 'rows' => '4', 'id' => 'meta-description']) }}
                </div>
            </div><!-- /.card-body -->
        </div>
        </div>
        <div class="col-md-4">
            @template('larapress.blog.sidebar.before')

            <div class="card">
                <div class="card-body">
                    <div class="form-group">
                        {{ Form::label('status', 'Status') }}
                        <select name="status" class="form-control">
                            <option value="1" {{$post->status == '1' ? 'selected' : ''}}>Published</option>
                            <option value="0" {{$post->status == '0' ? 'selected' : ''}}>Draft</option>
                        </select>
                    </div>
                    <div class="form-group">
                        {{ Form::label('data', 'Publish Date') }}
                        <input type="text" class="form-control seshra-date-range" name="date" value="{{$post->created_at}}" data-single="true" data-time-picker="true" data-format="YYYY-MM-DD HH:mm:ss">
                    </div>
                </div><!--form control-->
            </div><!--card-->

            <div class="card">
                <div class="card-header with-border">
                    <h3 class="card-title">{{ trans('validation.attributes.backend.category.categories') }}</h3>
                </div><!-- /.card-header -->
                <div class="card-body">
                    <div class="form-group">
                        {{ Form::hidden('category_id',$post->category_id,['id' => 'category_id']) }}
                        <div id="selectCategory">
                            <ul>
                                @include('admin.blogs.categories',['categories' => $categories])
                            </ul>
                        </div>
                    </div>
                    <div class="form-group">
                        {{ Form::label('parent', trans('validation.attributes.backend.tag.tags')) }}
                        <input type="text" class="form-control seshra-tag-input" id="tags" name="tags" data-on-change="load_tags" data-keydown="true" data-whitelist ="" value="{{ ($post->tags) ? implode(',', $post->tags()->pluck('title')->toArray()) : ''}}" placeholder="Type and hit enter to add a tag">
                    </div>
                </div><!--form control-->
            </div><!--card-->
            
            <div class="card">
                <div class="card-header with-border">
                    <h3 class="card-title">Featured</h3>
                </div><!-- /.card-header -->

                <div class="card-body">
                    <div class="form-group">
                        <div class="input-group" data-toggle="seshra-uploader" data-type="image" data-group="blogs">
                            <div class="input-group-prepend">
                                <div class="input-group-text bg-soft-secondary font-weight-medium">Browse</div>
                            </div>
                            <div class="form-control file-amount">Choose Image</div>
                            <input type="hidden" name="media_id" class="selected-files" value="{{$post->media_id}}">
                        </div>
                        <div class="file-preview box sm">
                        </div>
                    </div>
                </div><!-- /.card-body -->
            </div><!--card-->

            @template('larapress.blog.sidebar.after', ['blog' => $post])

            <div class="card position-sticky" style="top: 30px">
                <div class="card-body">
                    <div class="form-group">
                        {{ Form::submit(trans('buttons.general.crud.update'), ['class' => 'btn btn-success btn-md']) }}
                    </div>
                </div><!--form control-->
            </div><!--card-->
        </div>
    </div>
    {{ Form::close() }}
</div>
@stop
@push('before-scripts')
<script>
    var tagsearchurl = base_url + '/admin/api/tag/search';
    var timeout;
    function load_tags(e, taggy) {
        var tagify = $('#tags').data('tagify');
        if(e.type == 'input' && taggy.value.length > 2) {
            tagify.settings.whitelist.length = 0;
            if (taggy === undefined) return;
            tagify.loading(true);
            if (timeout) {
                clearTimeout(timeout);
            }
            timeout = setTimeout(function() {
                $.ajax({
                    type: "POST",
                    url: tagsearchurl,
                    data: { q: taggy.value },
                    success: function(data) {
                        tagify.loading(false);
                        if (data.status !== false) {
                            tagify.settings.whitelist.push(...data.data, taggy.value);
                            tagify.dropdown.show.call(tagify);
                        }
                    },
                    error: function() {
                        tagify.loading(false);
                        tagify.dropdown.hide.call(tagify, taggy.value);
                        alert('Error!!! Contact Administrator')
                    }
                });
            }, 700);
        }
    }
</script>
@endpush
@push('after-scripts')
<script>
    
    $(function () {
        $('#meta-title').on('keyup', function() {
            var length = $(this).val().length;
            if(length > 60) {
                $('#meta_title_length').addClass('red');
                $('#meta_title_length').removeClass('green');
            }
            else{
                $('#meta_title_length').removeClass('red');
                $('#meta_title_length').addClass('green');
            }
            $('#meta_title_length').html(+length+ ' characters');
        });
        $('#meta-description').on('keyup', function() {
            var length = $(this).val().length;
            if(length > 160) {
                $('#meta_description_length').addClass('red');
                $('#meta_description_length').removeClass('green');
            }
            else{
                $('#meta_description_length').removeClass('red')
                $('#meta_title_length').addClass('green');;
            }
            $('#meta_description_length').html(+length+ ' characters');
        });
    });
</script>
    
@endpush
