@extends ('admin.layouts.app')

@section ('title', trans('labels.backend.blog.deleted'))

@section('after-styles')
{{ style('vendor/datatables-bs4/css/dataTables.bootstrap4.min.css') }}
{{ style('vendor/datatables-responsive/css/responsive.bootstrap4.min.css') }}
@stop

@section('page-header')    
        <h1>
            {{ trans('labels.backend.blog.management') }}
            <small>{{ trans('labels.backend.blog.deleted') }}</small>
        </h1>
@endsection

@section('content')
    <div class="card">
        <div class="card-header with-border">
            <h3 class="card-title">{{ trans('labels.backend.blog.deleted') }}</h3>

            <div class="card-tools float-right">
                    <button type="button" id="delete_button" class="btn btn-xs btn-danger" style="display:none;" onclick="return confirm('Are you sure want to permanently delete these posts?');">Delete</button>
                {{ link_to_route('admin.blog.index', trans('menus.backend.blog.all'), [], ['class' => 'btn btn-success btn-xs']) }}
            </div><!--card-tools float-right-->
        </div><!-- /.card-header -->

            <div class="card-body">
                <div class="table-responsive">
                    <table id="blogs-table" class="table table-condensed table-hover">
                        <thead>
                        <tr>
                        <th><input type="checkbox" name="select_all" id="select_all"></th>
                        <th>{{ trans('labels.backend.table.id') }}</th>
                        <th>{{ trans('labels.backend.table.title') }}</th>
                        <th>Author</th>
                        <th>Category</th>
                        <th>{{ trans('labels.backend.table.created') }}</th>
                        <th>{{ trans('labels.backend.table.last_updated') }}</th>
                        <th>{{ trans('labels.general.actions') }}</th>
                        </tr>
                        </thead>
                    </table>
                </div><!--table-responsive-->
            </div><!-- /.card-body -->
        </div><!--box-->

        @stop
        @push('after-scripts')
            <!-- DataTables -->
            {{ script('vendor/datatables/jquery.dataTables.min.js') }}
            {{ script('vendor/datatables-bs4/js/dataTables.bootstrap4.min.js') }}

            <script>
                $(function() {
                    var table = $('#blogs-table').DataTable({
                        processing: true,
                        serverSide: true,
                        ajax: {
                            url: '{{ route("admin.blogs.get") }}',
                            type: 'post',
                            data: {trashed: true, _token: Laravel.csrfToken}
                        },
                        columns: [
                            {data: 'select', name: 'select', searchable: false, sortable: false},
                            {data: 'id', name: 'id'},
                            {data: 'title', name: 'title'},
                            {data: 'author', name: 'author', searchable: false, sortable: false},
                            {data: 'category', name: 'category'},
                            {data: 'created_at', name: 'created_at'},
                            {data: 'updated_at', name: 'updated_at'},
                            {data: 'actions', name: 'actions', searchable: false, sortable: false}
                        ],
                        order: [[1, "asc"]],
                        searchDelay: 500
                    });

                    $("body").on("click", "a[name='delete_blog_perm']", function(e) {
                        e.preventDefault();
                        var linkURL = $(this).attr("href");

                        Swal.fire({
                            title: "{{ trans('strings.backend.general.are_you_sure') }}",
                            text: "{{ trans('strings.backend.general.delete_confirm',['attribute'=>'blog']) }}",
                            icon: "warning",
                            showCancelButton: true,
                            confirmButtonColor: "#DD6B55",
                            confirmButtonText: "{{ trans('strings.backend.general.continue') }}",
                            cancelButtonText: "{{ trans('buttons.general.cancel') }}",
                        }).then((result) => {
                    result.value && window.location.assign(linkURL);
                });
                    });

                    $("body").on("click", "a[name='restore_blog']", function(e) {
                        e.preventDefault();
                        var linkURL = $(this).attr("href");

                        Swal.fire({
                            title: "{{ trans('strings.backend.general.are_you_sure') }}",
                            text: "{{ trans('strings.backend.general.restore_confirm',['attribute'=>'blog']) }}",
                            icon: "warning",
                            showCancelButton: true,
                            confirmButtonColor: "#DD6B55",
                            confirmButtonText: "{{ trans('strings.backend.general.continue') }}",
                            cancelButtonText: "{{ trans('buttons.general.cancel') }}",
                        }).then((result) => {
                            result.value && window.location.assign(linkURL);
                        });
                    });

                     // Handle click on "Select all" control
                    $('#select_all').on('click', function(){
                        // Get all rows with search applied
                        var rows = table.rows({ 'search': 'applied' }).nodes();
                        // Check/uncheck checkboxes for all rows in the table
                        $('input[type="checkbox"]', rows).prop('checked', this.checked);
                        if(!this.checked){
                            $('#delete_button').hide();
                            $('#selected_data div').html('');
                        }else{
                            $('#delete_button').show();
                        }
                    });

                    // Handle click on checkbox to set state of "Select all" control
                    $('#blogs-table tbody').on('change', 'input[type="checkbox"]', function(){
                        // If checkbox is not checked
                        if(!this.checked){
                            var el = $('#select_all').get(0);
                            // If "Select all" control is checked and has 'indeterminate' property
                            if(el && el.checked && ('indeterminate' in el)){
                                // Set visual state of "Select all" control
                                // as 'indeterminate'
                                el.indeterminate = true;
                            }
                            
                        }
                        $('#delete_button').show();
                    });

                    // Handle form submission event
                    $('#delete_button').on('click', function(e){          
                        $.ajax({
                            url: base_url+'/admin/blog/delete',
                            type: 'get',
                            dataType: 'json',
                            data: table.$('input[type="checkbox"]').serialize(),
                            success: function(data) {
                                if(data.status)
                                    table.ajax.reload();
                            }
                        });
                    });
                });
            </script>
@endpush
