<?php

return [

    /*
    |--------------------------------------------------------------------------
    | Labels Language Lines
    |--------------------------------------------------------------------------
    |
    | The following language lines are used in labels throughout the system.
    | Regardless where it is placed, a label can be listed here so it is easily
    | found in a intuitive way.
    |
    */

    'general' => [
        'all' => 'सबै',
        'yes' => 'हो',
        'no' => 'होइन',
        'custom' => 'Custom',
        'actions' => 'Actions',
		'active' => 'सक्रिय',
        'buttons' => [
            'save' => 'सुरक्षित गर्नुहोस्',
            'update' => 'सम्पादन गर्नुहोस्',
        ],
        'hide' => 'Hide',
		'inactive' => 'Inactive',
        'none' => 'None',
        'show' => 'Show',
        'toggle_navigation' => 'Toggle Navigation',
    ],

    'backend' => [
        'access' => [
            'roles' => [
                'create' => 'Create Role',
                'edit' => 'Edit Role',
                'management' => 'Role',

                'table' => [
                    'number_of_users' => 'Number of Users',
                    'permissions' => 'Permissions',
                    'role' => 'Role',
                    'sort' => 'Sort',
                    'total' => 'role total|roles total',
                ],
            ],

            'users' => [
                'active' => 'Active Users',
                'all_permissions' => 'All Permissions',
                'change_password' => 'Change Password',
                'change_password_for' => 'Change Password for :user',
                'create' => 'Create User',
                'deactivated' => 'Deactivated Users',
                'deleted' => 'Deleted Users',
                'edit' => 'Edit User',
                'management' => 'User',
                'no_permissions' => 'No Permissions',
                'no_roles' => 'No Roles to set.',
                'permissions' => 'Permissions',

                'table' => [
                    'confirmed' => 'Confirmed',
                    'created' => 'Created',
                    'email' => 'E-mail',
                    'slug' => 'Slug',
                    'id' => 'ID',
                    'last_updated' => 'Last Updated',
                    'name' => 'Name',
                    'no_deactivated' => 'No Deactivated Users',
                    'no_deleted' => 'No Deleted Users',
                    'roles' => 'Roles',
                    'total' => 'user total|users total',
                ],

				'tabs' => [
					'titles' => [
						'overview' => 'Overview',
						'history' => 'History',
					],

					'content' => [
						'overview' => [
							'avatar' => 'Avatar',
							'confirmed' => 'Confirmed',
							'created_at' => 'Created At',
							'deleted_at' => 'Deleted At',
							'email' => 'E-mail',
							'last_updated' => 'Last Updated',
							'name' => 'Name',
							'status' => 'Status',
						],
					],
				],

				'view' => 'View User',
            ],
        ],
        'comment' => [
            'active' => 'सक्रिय टिप्पणी',
            'comments' => 'टिप्पणीहरू',
            'management' => 'टिप्पणी',
        ],
        'page' => [
            'active' => 'सक्रिय पृष्ठहरू',
            'create' => 'पृष्ठ बनाउनुहोस्',
            'edit' => 'पृष्ठहरू सम्पादन गर्नुहोस्',
            'deleted' => 'मेटाइएको पानाहरू',
            'management' => 'पृष्ठ',
        ],
        'blog' => [
            'active' => 'सक्रिय पोस्टहरू',
            'create' => 'पोस्ट बनाउनुहोस्',
            'edit' => 'पोस्ट सम्पादन गर्नुहोस्',
            'deleted' => 'हटाइएको पोस्टहरू',
            'management' => 'पोस्ट',
        ],
        'settings' => [
            'management' => 'सेटिङ्हरू',
            'general' => 'General सेटिङ्हरू',
            'seo' => 'Seo सेटिङ्हरू',
            'social' => 'Social सेटिङ्हरू',
            'miscellaneous' => 'Miscellaneous सेटिङ्हरू',
        ],
        'theme' => [
            'management' => 'थीम',
            'manage' =>'Manage थीम',
        ],
        'menu' => [
            'management' => 'मेनु',
            'create' => 'मेनु बनाउनुहोस्'
        ],
        'block' => [
            'management' => 'ब्लक',
            'manage' => 'Manage ब्लक',
            'create' => 'ब्लक बनाउनुहोस्',
            'active' => 'सक्रिय ब्लक',
        ],
        'category' => [
            'management' => 'वर्ग',
            'create' => 'Create वर्ग',
            'edit' => 'Edit वर्ग',
            'all' => 'All वर्गहरू',
        ],
        'slider' => [
            'active' => 'Active स्लाइडर',
            'management' => 'स्लाइडर',
            'create' => 'Create स्लाइडर',
            'edit' => 'Edit स्लाइडर',
            'all' => 'All स्लाइडर'
        ],
        'sliderItems' => [
            'active' => 'Active स्लाइडर Items',
            'management' => 'स्लाइडर Items',
            'create' => 'Create स्लाइडर Items',
            'edit' => 'Edit स्लाइडर Items',
            'all' => 'All स्लाइडर Items'
        ],
        'media' => [
            'active' => 'Active मिडिया',
            'management' => 'मिडिया',
            'create' => 'Create मिडिया',
            'edit' => 'Edit मिडिया',
            'all' => 'All मिडिया'
        ],
        'table' => [
            'confirmed' => 'पुष्टि भयो',
            'created' => 'सिर्जना गरियो',
            'email' => 'ई-मेल',
            'id' => 'ID',
            'slug' => 'Slug',
            'last_updated' => 'Last Updated',
            'name' => 'Name',
            'no_deleted' => 'No Deleted',
            'title' => 'Title',
            'description' => 'Description',
            'created_at' => 'Created At',
            'deleted_at' => 'Deleted At',
        ],
    ],

    'frontend' => [

        'auth' => [
            'login_box_title' => 'Login',
            'login_button' => 'Login',
            'login_with' => 'Login with :social_media',
            'register_box_title' => 'Register',
            'register_button' => 'Register',
            'remember_me' => 'Remember Me',
        ],

        'passwords' => [
            'forgot_password' => 'Forgot Your Password?',
            'reset_password_box_title' => 'Reset Password',
            'reset_password_button' => 'Reset Password',
            'send_password_reset_link_button' => 'Send Password Reset Link',
        ],

        'macros' => [
            'country' => [
                'alpha' => 'Country Alpha Codes',
                'alpha2' => 'Country Alpha 2 Codes',
                'alpha3' => 'Country Alpha 3 Codes',
                'numeric' => 'Country Numeric Codes',
            ],

            'macro_examples' => 'Macro Examples',

            'state' => [
                'mexico' => 'Mexico State List',
                'us' => [
                    'us' => 'US States',
                    'outlying' => 'US Outlying Territories',
                    'armed' => 'US Armed Forces',
                ],
            ],

            'territories' => [
                'canada' => 'Canada Province & Territories List',
            ],

            'timezone' => 'Timezone',
        ],

        'user' => [
            'passwords' => [
                'change' => 'Change Password',
            ],

            'profile' => [
                'avatar' => 'Avatar',
                'created_at' => 'Created At',
                'edit_information' => 'Edit Information',
                'email' => 'E-mail',
                'last_updated' => 'Last Updated',
                'name' => 'Name',
                'update_information' => 'Update Information',
            ],
        ],

    ],
];
