<?php

return [

    /*
    |--------------------------------------------------------------------------
    | Menus Language Lines
    |--------------------------------------------------------------------------
    |
    | The following language lines are used in menu items throughout the system.
    | Regardless where it is placed, a menu item can be listed here so it is easily
    | found in a intuitive way.
    |
    */

    'backend' => [
        'access' => [
            'title' => 'Access',

            'roles' => [
                'all' => 'All Roles',
                'create' => 'Create Role',
                'edit' => 'Edit Role',
                'management' => 'Role',
                'main' => 'Roles',
            ],

            'users' => [
                'all' => 'All Users',
                'change-password' => 'Change Password',
                'create' => 'Create User',
                'deactivated' => 'Deactivated Users',
                'deleted' => 'Deleted Users',
                'edit' => 'Edit User',
                'main' => 'Users',
				'view' => 'View User',
            ],
        ],

        'log-viewer' => [
            'main' => 'Log Viewer',
            'dashboard' => 'Dashboard',
            'logs' => 'Logs',
        ],

        'sidebar' => [
            'dashboard' => 'Dashboard',
            'general' => 'General',
			'system' => 'System',
        ],
        'page' => [
            'all' => 'All Pages',
            'create' => 'Create Page',
            'deleted' => 'Deleted Pages',
            'edit' => 'Edit Page',
            'main' => 'Pages',
            'view' => 'View Page',
            'management' => 'Page',
        ],
        'blog' => [
            'all' => 'All Posts',
            'create' => 'Create Post',
            'deleted' => 'Deleted Posts',
            'edit' => 'Edit Post',
            'main' => 'Posts',
            'view' => 'View Post',
            'management' => 'Post',
        ],
        'media' => [
            'all' => 'All Media',
            'create' => 'Add Media',
            'deleted' => 'Deleted Media',
            'edit' => 'Edit Media',
            'main' => 'Media',
            'view' => 'View Media',
            'management' => 'Media',
        ],
        'menu' => [
            'management' => 'Menu'
        ],
        'category' => [
            'management' => 'Category'
        ],
        'tag' => [
            'management' => 'Tags'
        ],
        'theme' => [
            'management' => 'Theme'
        ],
        'settings' => [
            'main' => 'Settings',
            'general' => 'General Settings', 
            'seo' => 'Seo Settings',
            'miscellaneous' => 'Miscellaneous Settings',
            'social' => 'Social Settings',
            'backup_restore' => 'Backup & Restore',
            'backup' => 'Backup',
            'restore' => 'Restore'
        ],
        'comments' => [
            'main' => 'Comments',
            'deleted' => 'Deleted Comments'
        ],
        'slider' => [
            'all' => 'All Slider',
            'create' => 'Create Slider',
            'deleted' => 'Deleted Slider',
            'edit' => 'Edit SLider',
            'main' => 'Sliders',
            'view' => 'View Slider',
            'management' => 'Slider',
        ],
        'sliderItems' => [
            'all' => 'All Slider Items',
            'create' => 'Create Slide',
            'deleted' => 'Deleted Slide',
            'edit' => 'Edit Slide',
            'main' => 'Slides',
            'view' => 'View Slide',
            'management' => 'Slide',
        ],
        'block' => [
            'all' => 'All Blocks',
            'create' => 'Create Block',
            'deleted' => 'Deleted Block',
            'edit' => 'Edit Block',
            'main' => 'Blocks',
            'view' => 'View Block',
            'management' => 'Block Management',
        ],
        'widgets' => [
            'all' => 'All Widgets',
            'create' => 'Create Widget',
            'deleted' => 'Deleted Widget',
            'edit' => 'Edit Widget',
            'main' => 'Widgets',
            'view' => 'View Widget',
            'management' => 'Widget Management',
        ],
        'gallery' => [
            'all' => 'All Gallery',
            'create' => 'Create Gallery',
            'edit' => 'Edit Gallery',
            'main' => 'Gallery',
            'view' => 'View Gallery',
            'management' => 'Gallery Management',
        ],
        'gallery_items' => [
            'all' => 'All Gallery Items',
            'create' => 'Create Gallery Item',
            'edit' => 'Edit Gallery Item',
            'main' => 'Gallery Item',
            'view' => 'View Gallery Item',
            'management' => 'Gallery Item Management',
        ],
        'packages' => [
            'all' => 'All Packages',
            'upload' => 'Upload',
            'main' => 'Package',
            'management' => 'Package Management',
        ]
    ],

    'language-picker' => [
        'language' => 'Language',
        /**
         * Add the new language to this array.
         * The key should have the same language code as the folder name.
         * The string should be: 'Language-name-in-your-own-language (Language-name-in-English)'.
         * Be sure to add the new language in alphabetical order.
         */
        'langs' => [
            'ar' => 'Arabic',
            'da' => 'Danish',
            'de' => 'German',
            'en' => 'English',
            'es' => 'Spanish',
            'fr' => 'French',
            'it' => 'Italian',
			'nl' => 'Dutch',
            'pt_BR' => 'Brazilian Portuguese',
            'sv' => 'Swedish',
            'th' => 'Thai',
            'np' => 'Nepali'
        ],
    ],
];
