<?php

return [

    /*
    |--------------------------------------------------------------------------
    | Labels Language Lines
    |--------------------------------------------------------------------------
    |
    | The following language lines are used in labels throughout the system.
    | Regardless where it is placed, a label can be listed here so it is easily
    | found in a intuitive way.
    |
    */

    'general' => [
        'all' => 'All',
        'yes' => 'Yes',
        'no' => 'No',
        'custom' => 'Custom',
        'actions' => 'Actions',
		'active' => 'Active',
        'buttons' => [
            'save' => 'Save',
            'update' => 'Update',
        ],
        'hide' => 'Hide',
		'inactive' => 'Inactive',
        'none' => 'None',
        'show' => 'Show',
        'toggle_navigation' => 'Toggle Navigation',
    ],

    'backend' => [
        'access' => [
            'roles' => [
                'create' => 'Create Role',
                'edit' => 'Edit Role',
                'management' => 'Role',

                'table' => [
                    'number_of_users' => 'Number of Users',
                    'permissions' => 'Permissions',
                    'role' => 'Role',
                    'sort' => 'Sort',
                    'total' => 'role total|roles total',
                ],
            ],

            'users' => [
                'active' => 'Active Users',
                'all_permissions' => 'All Permissions',
                'change_password' => 'Change Password',
                'change_password_for' => 'Change Password for :user',
                'create' => 'Create User',
                'deactivated' => 'Deactivated Users',
                'deleted' => 'Deleted Users',
                'edit' => 'Edit User',
                'management' => 'User',
                'no_permissions' => 'No Permissions',
                'no_roles' => 'No Roles to set.',
                'permissions' => 'Permissions',

                'table' => [
                    'confirmed' => 'Confirmed',
                    'created' => 'Created',
                    'email' => 'E-mail',
                    'slug' => 'Slug',
                    'id' => 'ID',
                    'last_updated' => 'Last Updated',
                    'name' => 'Name',
                    'no_deactivated' => 'No Deactivated Users',
                    'no_deleted' => 'No Deleted Users',
                    'roles' => 'Roles',
                    'total' => 'user total|users total',
                ],

				'tabs' => [
					'titles' => [
						'overview' => 'Overview',
						'history' => 'History',
					],

					'content' => [
						'overview' => [
							'avatar' => 'Avatar',
							'confirmed' => 'Confirmed',
							'created_at' => 'Created At',
							'deleted_at' => 'Deleted At',
							'email' => 'E-mail',
							'last_updated' => 'Last Updated',
							'name' => 'Name',
							'status' => 'Status',
						],
					],
				],

				'view' => 'View User',
            ],
        ],
        'comment' => [
            'active' => 'Active Comment',
            'comments' => 'Comments',
            'management' => 'Comment',
            'deleted' => 'Deleted Comment',
        ],
        'page' => [
            'active' => 'Active Pages',
            'create' => 'Create Page',
            'edit' => 'Edit Page',
            'deleted' => 'Deleted Pages',
            'management' => 'Page',
        ],
        'blog' => [
            'active' => 'Active Posts',
            'create' => 'Create Post',
            'edit' => 'Edit Post',
            'deleted' => 'Deleted Posts',
            'management' => 'Post',
        ],
        'settings' => [
            'management' => 'Settings',
            'general' => 'General Settings',
            'seo' => 'Seo Settings',
            'social' => 'Social Settings',
            'miscellaneous' => 'Miscellaneous Settings',
            'backup_restore' => 'Backup & Restore',
            'backup' => 'Backup',
            'restore' => 'Restore'
        ],
        'theme' => [
            'management' => 'Theme',
            'manage' =>'Manage Theme',
            'editor' => 'Theme Editor'
        ],
        'menu' => [
            'management' => 'Menu',
            'create' => 'Add Menu',
            'pages' => 'Pages',
            'posts' => 'Posts',
            'custom_link' => 'Custom Links'
        ],
        'block' => [
            'management' => 'Block',
            'manage' => 'Manage Block',
            'create' => 'Add Block',
            'active' => 'Active Blocks',
        ],
        'category' => [
            'management' => 'Category',
            'create' => 'Create Category',
            'edit' => 'Edit Category',
            'all' => 'All Categories',
        ],
        'tag' => [
            'management' => 'Tags',
            'create' => 'Create Tag',
            'edit' => 'Edit Tag',
            'all' => 'All Tags',
        ],
        'gallery' => [
            'active' => 'Active Gallery',
            'management' => 'Gallery',
            'create' => 'Create Gallery',
            'edit' => 'Edit Gallery',
            'all' => 'All Gallery'
        ],
        'slider' => [
            'active' => 'Active Sliders',
            'management' => 'Slider',
            'create' => 'Create Slider',
            'edit' => 'Edit Slider',
            'all' => 'All Sliders'
        ],
        'sliderItems' => [
            'active' => 'Active Slider Items',
            'management' => 'SliderItems',
            'create' => 'Create Slider Items',
            'edit' => 'Edit Slider Items',
            'all' => 'All Slider Items'
        ],
        'media' => [
            'active' => 'Active Media',
            'management' => 'Media',
            'create' => 'Create Media',
            'edit' => 'Edit Media',
            'all' => 'All Media'
        ],
        'table' => [
            'confirmed' => 'Confirmed',
            'created' => 'Created',
            'email' => 'E-mail',
            'id' => 'ID',
            'slug' => 'Slug',
            'last_updated' => 'Last Updated',
            'name' => 'Name',
            'image' => 'Image',
            'no_deleted' => 'No Deleted',
            'title' => 'Title',
            'description' => 'Description',
            'status' => 'Status',
            'created_at' => 'Created At',
            'deleted_at' => 'Deleted At',
        ],
    ],

    'frontend' => [

        'auth' => [
            'login_box_title' => 'Login',
            'login_button' => 'Login',
            'login_with' => 'Login with :social_media',
            'register_box_title' => 'Register',
            'register_button' => 'Register',
            'remember_me' => 'Remember Me',
        ],

        'passwords' => [
            'forgot_password' => 'Forgot Your Password?',
            'reset_password_box_title' => 'Reset Password',
            'reset_password_button' => 'Reset Password',
            'send_password_reset_link_button' => 'Send Password Reset Link',
        ],

        'macros' => [
            'country' => [
                'alpha' => 'Country Alpha Codes',
                'alpha2' => 'Country Alpha 2 Codes',
                'alpha3' => 'Country Alpha 3 Codes',
                'numeric' => 'Country Numeric Codes',
            ],

            'macro_examples' => 'Macro Examples',

            'state' => [
                'mexico' => 'Mexico State List',
                'us' => [
                    'us' => 'US States',
                    'outlying' => 'US Outlying Territories',
                    'armed' => 'US Armed Forces',
                ],
            ],

            'territories' => [
                'canada' => 'Canada Province & Territories List',
            ],

            'timezone' => 'Timezone',
        ],

        'user' => [
            'passwords' => [
                'change' => 'Change Password',
            ],

            'profile' => [
                'avatar' => 'Avatar',
                'created_at' => 'Created At',
                'edit_information' => 'Edit Information',
                'email' => 'E-mail',
                'last_updated' => 'Last Updated',
                'name' => 'Name',
                'update_information' => 'Update Information',
            ],
        ],

    ],
];
