<?php

return [

    /*
    |--------------------------------------------------------------------------
    | Exception Language Lines
    |--------------------------------------------------------------------------
    |
    | The following language lines are used in Exceptions thrown throughout the system.
    | Regardless where it is placed, a button can be listed here so it is easily
    | found in a intuitive way.
    |
    */

    'backend' => [
        'access' => [
            'roles' => [
                'already_exists' => 'That role already exists. Please choose a different name.',
                'cant_delete_admin' => 'You can not delete the Administrator role.',
                'create_error' => 'There was a problem creating this role. Please try again.',
                'delete_error' => 'There was a problem deleting this role. Please try again.',
                'has_users' => 'You can not delete a role with associated users.',
                'needs_permission' => 'You must select at least one permission for this role.',
                'not_found' => 'That role does not exist.',
                'update_error' => 'There was a problem updating this role. Please try again.',
            ],

            'users' => [
                'cant_deactivate_self' => 'You can not do that to yourself.',
                'cant_delete_self' => 'You can not delete yourself.',
				'cant_restore' => 'This user is not deleted so it can not be restored.',
                'create_error' => 'There was a problem creating this user. Please try again.',
                'delete_error' => 'There was a problem deleting this user. Please try again.',
				'delete_first' => 'This user must be deleted first before it can be destroyed permanently.',
                'email_error' => 'That email address belongs to a different user.',
                'mark_error' => 'There was a problem updating this user. Please try again.',
                'not_found' => 'That user does not exist.',
                'restore_error' => 'There was a problem restoring this user. Please try again.',
                'role_needed_create' => 'You must choose at lease one role.',
                'role_needed' => 'You must choose at least one role.',
                'update_error' => 'There was a problem updating this user. Please try again.',
                'update_password_error' => 'There was a problem changing this users password. Please try again.',
            ],
        ],
        'page' => [
            'cant_restore' => 'This page is not deleted so it can not be restored.',
            'create_error' => 'There was a problem creating this page. Please try again.',
            'delete_error' => 'There was a problem deleting this page. Please try again.',
            'delete_first' => 'This page must be deleted first before it can be destroyed permanently.',
            'mark_error' => 'There was a problem updating this page. Please try again.',
            'not_found' => 'That page does not exist.',
            'restore_error' => 'There was a problem restoring this page. Please try again.',
            'update_error' => 'There was a problem updating this page. Please try again.',
        ],
        'blog' => [
            'cant_restore' => 'This blog is not deleted so it can not be restored.',
            'create_error' => 'There was a problem creating this blog. Please try again.',
            'delete_error' => 'There was a problem deleting this blog. Please try again.',
            'delete_first' => 'This blog must be deleted first before it can be destroyed permanently.',
            'mark_error' => 'There was a problem updating this blog. Please try again.',
            'not_found' => 'That blog does not exist.',
            'restore_error' => 'There was a problem restoring this blog. Please try again.',
            'update_error' => 'There was a problem updating this blog. Please try again.',
        ],
         'menu' => [
            'create_error' => 'There was a problem creating this menu. Please try again.',
            'delete_error' => 'There was a problem deleting this menu. Please try again.',
            'not_found' => 'That menu does not exist.',
            'update_error' => 'There was a problem updating this menu. Please try again.',
            'parent_error' => 'You cannot delete parent menu. Please delete child menu first.',
        ],
        'category' => [
            'parent_error' => 'Please delete child category first.',
            'delete_not_available' => 'You cannot delete this category.',
            'delete_error' => 'There was a problem deleting this category. Please try again.',
            'create_error' => 'There was a problem creating this category. Please try again.',
             'not_found' => 'That category does not exist.',
            'update_error' => 'There was a problem updating this category. Please try again.',  
        ],
        'product' => [
              'create_error' => 'There was a problem creating this product. Please try again.',  
        ],

    ],

    'frontend' => [
        'auth' => [
            'confirmation' => [
                'already_confirmed' => 'Your account is already confirmed.',
                'confirm' => 'Confirm your account!',
                'created_confirm' => 'Your account was successfully created. We have sent you an e-mail to confirm your account.',
                'mismatch' => 'Your confirmation code does not match.',
                'not_found' => 'That confirmation code does not exist.',
                'resend' => 'Your account is not confirmed. Please click the confirmation link in your e-mail, or <a href="#">click here</a> to resend the confirmation e-mail.',
                'success' => 'Your account has been successfully confirmed!',
                'resent' => 'A new confirmation e-mail has been sent to the address on file.',
            ],

            'deactivated' => 'Your account has been deactivated.',
            'email_taken' => 'That e-mail address is already taken.',

            'password' => [
                'change_mismatch' => 'That is not your old password.',
                'reset_problem' => 'There was a problem resetting your password. Please resend the password reset email.',
            ],
            'registration_disabled' => 'Registration is currently closed.',
        ],
    ],
];
