(function($) {
    // USE STRICT
    "use strict";
    MEDIA.data = {
        csrf: $('meta[name="csrf-token"]').attr("content"),
        appUrl: $('meta[name="app-url"]').attr("content"),
        fileBaseUrl: $('meta[name="file-base-url"]').attr("content"),
        selectedItems: []
    };
    MEDIA.uploader = {
        data: {
            selectedFiles: [],
            selectedFilesObject: [],
            clickedForDelete: null,
            allFiles: [],
            multiple: false,
            type: "all",
            group: "others",
            utype: "emm",
            next_page_url: null,
            prev_page_url: null,
        },
        removeInputValue: function(id, array, elem) {
            var selected = array.filter(function(item) {
                return item !== id;
                console.log(selected);
            });
            if (selected.length > 0) {
                $(elem)
                    .find(".file-amount")
                    .html(MEDIA.uploader.updateFileHtml(selected));
            } else {
                elem.find(".file-amount").html("Choose Image");
            }
            $(elem).find(".selected-files").val(selected);
        },
        removeAttachment: function() {
            
            $(document).on("click", '.remove-attachment', function() {
                if(MEDIA.uploader.data.utype == 'standalone') {
                    var value = $(this)
                    .closest(".file-preview-item")
                    .data("id");
                    var selected = $(this)
                        .closest(".file-preview")
                        .prev('.seshra-uploader-standalone')
                        .find(".selected-files")
                        .val()
                        .split(",")
                        .map(Number);

                    MEDIA.uploader.removeInputValue(
                        value,
                        selected,
                        $(this)
                        .closest(".file-preview")
                        .prev('.seshra-uploader-standalone')
                    );
                    $(this).closest(".file-preview").prev('.seshra-uploader-standalone').find('.upload').val("");
                    $(this).closest(".file-preview-item").remove();
                }else{
                    var value = $(this)
                    .closest(".file-preview-item")
                    .data("id");
                    var selected = $(this)
                        .closest(".file-preview")
                        .prev('[data-toggle="seshra-uploader"]')
                        .find(".selected-files")
                        .val()
                        .split(",")
                        .map(Number);

                    MEDIA.uploader.removeInputValue(
                        value,
                        selected,
                        $(this)
                        .closest(".file-preview")
                        .prev('[data-toggle="seshra-uploader"]')
                    );
                    $(this).closest(".file-preview-item").remove();
                }
                
            });
        },
        deleteUploaderFile: function() {
            $(".seshra-uploader-delete").each(function() {
                $(this).on("click", function(e) {
                    e.preventDefault();
                    var id = $(this).data("id");
                    MEDIA.uploader.data.clickedForDelete = id;
                    $("#seshraUploaderDelete").modal("show");

                    $(".seshra-uploader-confirmed-delete").on("click", function(
                        e
                    ) {
                        e.preventDefault();
                        if (e.detail === 1) {
                            var clickedForDeleteObject =
                                MEDIA.uploader.data.allFiles[
                                    MEDIA.uploader.data.allFiles.findIndex(
                                        (x) =>
                                        x.id ===
                                        MEDIA.uploader.data.clickedForDelete
                                    )
                                ];
                            $.ajax({
                                url: MEDIA.data.appUrl +
                                    "/seshra-uploader/destroy/" +
                                    MEDIA.uploader.data.clickedForDelete,
                                type: "DELETE",
                                dataType: "JSON",
                                data: {
                                    id: MEDIA.uploader.data.clickedForDelete,
                                    _method: "DELETE",
                                    _token: MEDIA.data.csrf,
                                },
                                success: function() {
                                    MEDIA.uploader.data.selectedFiles = MEDIA.uploader.data.selectedFiles.filter(
                                        function(item) {
                                            return (
                                                item !==
                                                MEDIA.uploader.data
                                                .clickedForDelete
                                            );
                                        }
                                    );
                                    MEDIA.uploader.data.selectedFilesObject = MEDIA.uploader.data.selectedFilesObject.filter(
                                        function(item) {
                                            return (
                                                item !== clickedForDeleteObject
                                            );
                                        }
                                    );
                                    MEDIA.uploader.updateUploaderSelected();
                                    MEDIA.uploader.getAllUploads(
                                        MEDIA.data.appUrl +
                                        "/admin/filemanager/files",
                                        group
                                    );
                                    MEDIA.uploader.data.clickedForDelete = null;
                                    $("#seshraUploaderDelete").modal("hide");
                                },
                            });
                        }
                    });
                });
            });
        },
        uploadSelect: function() {
            $(".seshra-uploader-select").each(function() {
                var elem = $(this);
                elem.on("click", function(e) {
                    var value = $(this).data("value");
                    var valueObject =
                        MEDIA.uploader.data.allFiles[
                            MEDIA.uploader.data.allFiles.findIndex(
                                (x) => x.id === value
                            )
                        ];

                    elem.closest(".seshra-file-box-wrap").toggleAttr(
                        "data-selected",
                        "true",
                        "false"
                    );
                    if (!MEDIA.uploader.data.multiple) {
                        elem.closest(".seshra-file-box-wrap")
                            .siblings()
                            .attr("data-selected", "false");
                    }
                    if (!MEDIA.uploader.data.selectedFiles.includes(value)) {
                        if (!MEDIA.uploader.data.multiple) {
                            MEDIA.uploader.data.selectedFiles = [];
                            MEDIA.uploader.data.selectedFilesObject = [];
                        }
                        MEDIA.uploader.data.selectedFiles.push(value);
                        MEDIA.uploader.data.selectedFilesObject.push(valueObject);
                    } else {
                        MEDIA.uploader.data.selectedFiles = MEDIA.uploader.data.selectedFiles.filter(
                            function(item) {
                                return item !== value;
                            }
                        );
                        MEDIA.uploader.data.selectedFilesObject = MEDIA.uploader.data.selectedFilesObject.filter(
                            function(item) {
                                return item !== valueObject;
                            }
                        );
                    }
                    MEDIA.uploader.addSelectedValue();
                    MEDIA.uploader.updateUploaderSelected();
                });
            });
        },
        updateFileHtml: function(array) {
            var fileText = "";
            if (array.length > 1) {
                var fileText = "Files";
            } else {
                var fileText = "File";
            }
            return array.length + " " + fileText + " " + "selected";
        },
        updateUploaderSelected: function() {
            $(".seshra-uploader-selected").html(
                MEDIA.uploader.updateFileHtml(MEDIA.uploader.data.selectedFiles)
            );
        },
        clearUploaderSelected: function() {
            $(".seshra-uploader-selected-clear").on("click", function() {
                MEDIA.uploader.data.selectedFiles = [];
                MEDIA.uploader.addSelectedValue();
                MEDIA.uploader.addHiddenValue();
                MEDIA.uploader.resetFilter();
                MEDIA.uploader.updateUploaderSelected();
                MEDIA.uploader.updateUploaderFiles();
            });
        },
        resetFilter: function() {
            $('[name="seshra-uploader-search"]').val("");
            $('[name="seshra-show-selected"]').prop("checked", false);
            $('[name="seshra-uploader-sort"] option[value=newest]').prop(
                "selected",
                true
            );
        },
        getAllUploads: function(url, group, search_key = null, sort_key = null) {
            $(".seshra-uploader-all").html(
                '<div class="align-items-center d-flex h-100 justify-content-center w-100"><div class="spinner-border" role="status"></div></div>'
            );
            var params = {};
            if (search_key != null && search_key.length > 0) {
                params["search"] = search_key;
            }
            if (sort_key != null && sort_key.length > 0) {
                params["sort"] = sort_key;
            } else {
                params["sort"] = 'newest';
            }
            params["group"] = group;
            params["type"] = MEDIA.uploader.data.type;
            $.get(url, params, function(data, status) {
                if (typeof data == 'string') {
                    data = JSON.parse(data);
                }
                MEDIA.uploader.data.allFiles = data.data;
                MEDIA.uploader.allowedFileType();
                MEDIA.uploader.addSelectedValue();
                MEDIA.uploader.addHiddenValue();
                //MEDIA.uploader.resetFilter();
                MEDIA.uploader.updateUploaderFiles();
                if (data.next_page_url != null) {
                    MEDIA.uploader.data.next_page_url = data.next_page_url;
                    $("#uploader_next_btn").removeAttr("disabled");
                } else {
                    $("#uploader_next_btn").attr("disabled", true);
                }
                if (data.prev_page_url != null) {
                    MEDIA.uploader.data.prev_page_url = data.prev_page_url;
                    $("#uploader_prev_btn").removeAttr("disabled");
                } else {
                    $("#uploader_prev_btn").attr("disabled", true);
                }
            });
        },
        showSelectedFiles: function() {
            $('[name="seshra-show-selected"]').on("change", function() {
                if ($(this).is(":checked")) {
                   
                    MEDIA.uploader.data.allFiles =
                        MEDIA.uploader.data.selectedFilesObject;
                } else {
                  
                    MEDIA.uploader.getAllUploads(
                        MEDIA.data.appUrl + "/admin/filemanager/files"
                    );
                }
                MEDIA.uploader.updateUploaderFiles();
            });
        },
        searchUploaderFiles: function() {
            $('[name="seshra-uploader-search"]').on("keyup", function() {
                var value = $(this).val();
                MEDIA.uploader.getAllUploads(
                    MEDIA.data.appUrl + "/admin/filemanager/files",
                    value,
                    $('[name="seshra-uploader-sort"]').val()
                );
               
            });
        },
        sortUploaderFiles: function() {
            $('[name="seshra-uploader-sort"]').on("change", function() {
                var value = $(this).val();
                MEDIA.uploader.getAllUploads(
                    MEDIA.data.appUrl + "/admin/filemanager/files",
                    $('[name="seshra-uploader-search"]').val(),
                    value
                );

                if (value === "oldest") {
                    MEDIA.uploader.data.allFiles = MEDIA.uploader.data.allFiles.sort(
                        function(a, b) {
                            return (
                                new Date(a.created_at) - new Date(b.created_at)
                            );
                        }
                    );
                } else if (value === "smallest") {
                    MEDIA.uploader.data.allFiles = MEDIA.uploader.data.allFiles.sort(
                        function(a, b) {
                            return a.file_size - b.file_size;
                        }
                    );
                } else if (value === "largest") {
                    MEDIA.uploader.data.allFiles = MEDIA.uploader.data.allFiles.sort(
                        function(a, b) {
                            return b.file_size - a.file_size;
                        }
                    );
                } else {
                    MEDIA.uploader.data.allFiles = MEDIA.uploader.data.allFiles.sort(
                        function(a, b) {
                            a = new Date(a.created_at);
                            b = new Date(b.created_at);
                            return a > b ? -1 : a < b ? 1 : 0;
                        }
                    );
                }
                MEDIA.uploader.updateUploaderFiles();
            });
        },
        addSelectedValue: function() {
            for (var i = 0; i < MEDIA.uploader.data.allFiles.length; i++) {
                if (!MEDIA.uploader.data.selectedFiles.includes(
                        MEDIA.uploader.data.allFiles[i].id
                    )) {
                    MEDIA.uploader.data.allFiles[i].selected = false;
                } else {
                    MEDIA.uploader.data.allFiles[i].selected = true;
                }
            }
        },
        addHiddenValue: function() {
            for (var i = 0; i < MEDIA.uploader.data.allFiles.length; i++) {
                MEDIA.uploader.data.allFiles[i].aria_hidden = false;
            }
        },
        allowedFileType: function() {
            if (MEDIA.uploader.data.type !== "all") {
                MEDIA.uploader.data.allFiles = MEDIA.uploader.data.allFiles.filter(
                    function(item) {
                        return item.type === MEDIA.uploader.data.type;
                    }
                );
            }
        },
        updateUploaderFiles: function() {
            $(".seshra-uploader-all").html(
                '<div class="align-items-center d-flex h-100 justify-content-center w-100"><div class="spinner-border" role="status"></div></div>'
            );

            var data = MEDIA.uploader.data.allFiles;

            setTimeout(function() {
                $(".seshra-uploader-all").html(null);

                if (data.length > 0) {
                    for (var i = 0; i < data.length; i++) {
                        var thumb = "";
                        var hidden = "";
                        if (data[i].type === "image") {
                            thumb =
                                '<img src="' +
                                data[i].url +
                                '" class="img-fit">';
                        } else {
                            thumb = '<i class="fas fa-file"></i>';
                        }
                        var html =
                            '<div class="seshra-file-box-wrap" aria-hidden="' +
                            data[i].aria_hidden +
                            '" data-selected="' +
                            data[i].selected +
                            '">' +
                            '<div class="seshra-file-box">' +
                            // '<div class="dropdown-file">' +
                            // '<a class="dropdown-link" data-toggle="dropdown">' +
                            // '<i class="la la-ellipsis-v"></i>' +
                            // "</a>" +
                            // '<div class="dropdown-menu dropdown-menu-right">' +
                            // '<a href="' +
                            // MEDIA.data.fileBaseUrl +
                            // data[i].file_name +
                            // '" target="_blank" download="' +
                            // data[i].file_original_name +
                            // "." +
                            // data[i].extension +
                            // '" class="dropdown-item"><i class="la la-download mr-2"></i>Download</a>' +
                            // '<a href="#" class="dropdown-item seshra-uploader-delete" data-id="' +
                            // data[i].id +
                            // '"><i class="la la-trash mr-2"></i>Delete</a>' +
                            // "</div>" +
                            // "</div>" +
                            '<div class="card card-file seshra-uploader-select" title="' +
                            data[i].file_original_name +
                            "." +
                            data[i].extension +
                            '" data-value="' +
                            data[i].id +
                            '">' +
                            '<div class="card-file-thumb">' +
                            thumb +
                            "</div>" +
                            '<div class="card-body">' +
                            '<h6 class="d-flex">' +
                            '<span class="text-truncate title">' +
                            data[i].file_original_name +
                            "</span>" +
                            '<span class="ext">.' +
                            data[i].extension +
                            "</span>" +
                            "</h6>" +
                            "<p>" +
                            MEDIA.extra.bytesToSize(data[i].file_size) +
                            "</p>" +
                            "</div>" +
                            "</div>" +
                            "</div>" +
                            "</div>";

                        $(".seshra-uploader-all").append(html);
                    }
                } else {
                    $(".seshra-uploader-all").html(
                        '<div class="align-items-center d-flex h-100 justify-content-center w-100 nav-tabs"><div class="text-center"><h3>No files found</h3></div></div>'
                    );
                }
                MEDIA.uploader.uploadSelect();
                MEDIA.uploader.deleteUploaderFile();
            }, 300);
        },
        inputSelectPreviewGenerate: function(elem) {
            elem.find(".selected-files").val(MEDIA.uploader.data.selectedFiles);
            elem.find(".default-image").val(MEDIA.uploader.data.selectedFiles[0]);
            
            if(MEDIA.uploader.data.utype == 'standalone') {
                elem.parent().next(".file-preview").html(null);
            }else {
                elem.next(".file-preview").html(null);
            }

            if (MEDIA.uploader.data.selectedFiles.length > 0) {

                $.post(
                    MEDIA.data.appUrl + "/admin/filemanager/preview", { _token: MEDIA.data.csrf, ids: MEDIA.uploader.data.selectedFiles.toString() },
                    function(data) {

                        if(MEDIA.uploader.data.utype == 'standalone') {
                            elem.parent().next(".file-preview").html(null);
                        }else {
                            elem.next(".file-preview").html(null);
                        }

                        if (data.length > 0) {
                            elem.find(".file-amount").html(
                                MEDIA.uploader.updateFileHtml(data)
                            );
                            for (
                                var i = 0; i < data.length; i++
                            ) {
                                var thumb = "";
                                var selected = '';
                                if (i == 0) {
                                    selected = 'selected';
                                }
                                if (data[i].type === "image") {
                                    thumb =
                                        '<img src="' +
                                        data[i].url +
                                        '" class="img-fit">';
                                } else {
                                    thumb = '<i class="fas fa-file"></i>';
                                }
                                var html =
                                    '<div class="d-flex justify-content-between align-items-center mt-2 file-preview-item ' + selected + '" data-id="' +
                                    data[i].id +
                                    '" title="' +
                                    data[i].file_original_name +
                                    "." +
                                    data[i].extension +
                                    '">' +
                                    '<div class="align-items-center align-self-stretch d-flex justify-content-center thumb">' +
                                    thumb +
                                    "</div>" +
                                    '<div class="col body">' +
                                    '<h6 class="d-flex">' +
                                    '<span class="text-truncate title">' +
                                    data[i].file_original_name +
                                    "</span>" +
                                    '<span class="ext">.' +
                                    data[i].extension +
                                    "</span>" +
                                    "</h6>" +
                                    "<p>" +
                                    MEDIA.extra.bytesToSize(
                                        data[i].file_size
                                    ) +
                                    "</p>" +
                                    "</div>" +
                                    '<div class="remove">' +
                                    '<button class="btn btn-sm btn-link remove-attachment" type="button">' +
                                    '<i class="fas fa-times"></i>' +
                                    "</button>" +
                                    "</div>" +
                                    "</div>";
                                if(MEDIA.uploader.data.utype == 'standalone') {
                                    elem.parent().next(".file-preview").append(html);
                                    elem.prev(".upload").val(data[i].url);
                                }else {
                                    elem.next(".file-preview").append(html);
                                }
                            }
                        } else {
                            elem.find(".file-amount").html("Choose File");
                        }
                    });
            } else {
                elem.find(".file-amount").html("Choose File");
            }

            // if (MEDIA.uploader.data.selectedFiles.length > 0) {
            //     elem.find(".file-amount").html(
            //         MEDIA.uploader.updateFileHtml(MEDIA.uploader.data.selectedFiles)
            //     );
            //     for (
            //         var i = 0;
            //         i < MEDIA.uploader.data.selectedFiles.length;
            //         i++
            //     ) {
            //         var index = MEDIA.uploader.data.allFiles.findIndex(
            //             (x) => x.id === MEDIA.uploader.data.selectedFiles[i]
            //         );
            //         var thumb = "";
            //         if (MEDIA.uploader.data.allFiles[index].type == "image") {
            //             thumb =
            //                 '<img src="' +
            //                 MEDIA.data.appUrl +
            //                 "/public/" +
            //                 MEDIA.uploader.data.allFiles[index].file_name +
            //                 '" class="img-fit">';
            //         } else {
            //             thumb = '<i class="la la-file-text"></i>';
            //         }
            //         var html =
            //             '<div class="d-flex justify-content-between align-items-center mt-2 file-preview-item" data-id="' +
            //             MEDIA.uploader.data.allFiles[index].id +
            //             '" title="' +
            //             MEDIA.uploader.data.allFiles[index].file_original_name +
            //             "." +
            //             MEDIA.uploader.data.allFiles[index].extension +
            //             '">' +
            //             '<div class="align-items-center align-self-stretch d-flex justify-content-center thumb">' +
            //             thumb +
            //             "</div>" +
            //             '<div class="col body">' +
            //             '<h6 class="d-flex">' +
            //             '<span class="text-truncate title">' +
            //             MEDIA.uploader.data.allFiles[index].file_original_name +
            //             "</span>" +
            //             '<span class="ext">.' +
            //             MEDIA.uploader.data.allFiles[index].extension +
            //             "</span>" +
            //             "</h6>" +
            //             "<p>" +
            //             MEDIA.extra.bytesToSize(
            //                 MEDIA.uploader.data.allFiles[index].file_size
            //             ) +
            //             "</p>" +
            //             "</div>" +
            //             '<div class="remove">' +
            //             '<button class="btn btn-sm btn-link remove-attachment" type="button">' +
            //             '<i class="la la-close"></i>' +
            //             "</button>" +
            //             "</div>" +
            //             "</div>";

            //         elem.next(".file-preview").append(html);
            //     }
            // } else {
            //     elem.find(".file-amount").html("Choose File");
            // }
        },
        editorImageGenerate: function(elem) {
            if (MEDIA.uploader.data.selectedFiles.length > 0) {
                for (
                    var i = 0; i < MEDIA.uploader.data.selectedFiles.length; i++
                ) {
                    var index = MEDIA.uploader.data.allFiles.findIndex(
                        (x) => x.id === MEDIA.uploader.data.selectedFiles[i]
                    );
                    var thumb = "";
                    if (MEDIA.uploader.data.allFiles[index].type === "image") {
                        thumb =
                            '<img src="' +
                            MEDIA.uploader.data.allFiles[index].url +
                            '">';
                        elem[0].insertHTML(thumb);
                        // console.log(elem);
                    }
                }
            }
        },
        dismissUploader: function() {
            $("#seshraUploaderModal").on("hidden.bs.modal", function() {
                $(".seshra-uploader-backdrop").remove();
                $("#seshraUploaderModal").remove();
            });
        },
        trigger: function(
            elem = null,
            from = "",
            type = "all",
            group = 'others',
            selected = "",
            multiple = false,
            callback = null
        ) {
            // $("body").append('<div class="seshra-uploader-backdrop"></div>');

            var elem = $(elem);
            var multiple = multiple;
            var type = type;
            var group = group;
            var oldSelectedFiles = selected;
            if (oldSelectedFiles !== "") {
                MEDIA.uploader.data.selectedFiles = oldSelectedFiles
                    .split(",")
                    .map(Number);
            } else {
                MEDIA.uploader.data.selectedFiles = [];
            }
            if ("undefined" !== typeof type && type.length > 0) {
                MEDIA.uploader.data.type = type;
            }

            if (multiple) {
                MEDIA.uploader.data.multiple = multiple;
            }

            // setTimeout(function() {
            $.post(
                MEDIA.data.appUrl + "/admin/filemanager",
                function(data) {
                    $("body").append(data);
                    $("#seshraUploaderModal").modal("show");
                    MEDIA.uploader.seshraUppy(group);
                    MEDIA.uploader.getAllUploads(
                        MEDIA.data.appUrl + "/admin/filemanager/files",
                        group,
                        null,
                        $('[name="seshra-uploader-sort"]').val()
                    );
                    MEDIA.uploader.updateUploaderSelected();
                    MEDIA.uploader.clearUploaderSelected();
                    MEDIA.uploader.sortUploaderFiles();
                    MEDIA.uploader.searchUploaderFiles();
                    MEDIA.uploader.showSelectedFiles();
                    MEDIA.uploader.dismissUploader();

                    $("#uploader_next_btn").on("click", function() {
                        if (MEDIA.uploader.data.next_page_url != null) {
                            $('[name="seshra-show-selected"]').prop(
                                "checked",
                                false
                            );
                            MEDIA.uploader.getAllUploads(
                                MEDIA.uploader.data.next_page_url,
                                group
                            );
                        }
                    });

                    $("#uploader_prev_btn").on("click", function() {
                        if (MEDIA.uploader.data.prev_page_url != null) {
                            $('[name="seshra-show-selected"]').prop(
                                "checked",
                                false
                            );
                            MEDIA.uploader.getAllUploads(
                                MEDIA.uploader.data.prev_page_url,
                                group
                            );
                        }
                    });

                    $(".seshra-uploader-search i").on("click", function() {
                        $(this).parent().toggleClass("open");
                    });

                    $('[data-toggle="seshraUploaderAddSelected"]').on(
                        "click",
                        function() {
                            if (from === "input") {
                                MEDIA.uploader.inputSelectPreviewGenerate(elem);
                            } else if (from === "direct") {
                                callback(MEDIA.uploader.data.selectedFiles);
                            }
                            $("#seshraUploaderModal").modal("hide");
                        }
                    );
                }
            );
            // }, 50);
        },
        initForInput: function() {
            $(document).on("click", '[data-toggle="seshra-uploader"]', function(e) {
                if (e.detail === 1) {
                    var elem = $(this);
                    var multiple = elem.data("multiple");
                    var type = elem.data("type");
                    var group = elem.data("group");
                    var utype = elem.data("utype");
                    var oldSelectedFiles = elem.find(".selected-files").val();

                    multiple = !multiple ? "" : multiple;
                    type = !type ? "" : type;
                    oldSelectedFiles = !oldSelectedFiles ?
                        "" :
                        oldSelectedFiles;
                    MEDIA.uploader.data.utype = (utype == 'standalone') ? 'standalone' : 'emm';
                    MEDIA.uploader.trigger(
                        this,
                        "input",
                        type,
                        group,
                        oldSelectedFiles,
                        multiple
                    );
                }
            });
        },
        previewGenerate: function() {
            $('[data-toggle="seshra-uploader"]').each(function() {
                var $this = $(this);
                var files = $this.find(".selected-files").val();
                var default_img = $(this).find(".default-image").val();
                MEDIA.uploader.data.utype = $this.data("utype");

                $.post(
                    MEDIA.data.appUrl + "/admin/filemanager/preview", { _token: MEDIA.data.csrf, ids: files },
                    function(data) {

                        if(MEDIA.uploader.data.utype == 'standalone') {
                            $this.parent().next(".file-preview").html(null);
                        }else {                            
                            $this.next(".file-preview").html(null);
                        }

                        if (data.length > 0) {
                            $this.find(".file-amount").html(
                                MEDIA.uploader.updateFileHtml(data)
                            );
                            for (
                                var i = 0; i < data.length; i++
                            ) {
                                var selected = '';
                                var thumb = "";
                                if (data[i].type === "image") {
                                    thumb =
                                        '<img src="' +
                                        data[i].url +
                                        '" class="img-fit">';
                                } else {
                                    thumb = '<i class="fas fa-file"></i>';
                                }
                                if (default_img == data[i].id) {
                                    selected = 'selected';
                                }
                                var html =
                                    '<div class="d-flex justify-content-between align-items-center mt-2 file-preview-item ' + selected + '" data-id="' +
                                    data[i].id +
                                    '" title="' +
                                    data[i].file_original_name +
                                    "." +
                                    data[i].extension +
                                    '">' +
                                    '<div class="align-items-center align-self-stretch d-flex justify-content-center thumb">' +
                                    thumb +
                                    "</div>" +
                                    '<div class="col body">' +
                                    '<h6 class="d-flex">' +
                                    '<span class="text-truncate title">' +
                                    data[i].file_original_name +
                                    "</span>" +
                                    '<span class="ext">.' +
                                    data[i].extension +
                                    "</span>" +
                                    "</h6>" +
                                    "<p>" +
                                    MEDIA.extra.bytesToSize(
                                        data[i].file_size
                                    ) +
                                    "</p>" +
                                    "</div>" +
                                    '<div class="remove">' +
                                    '<button class="btn btn-sm btn-link remove-attachment" type="button">' +
                                    '<i class="fas fa-times"></i>' +
                                    "</button>" +
                                    "</div>" +
                                    "</div>";
                                if(MEDIA.uploader.data.utype == 'standalone') {
                                    $this.parent().next(".file-preview").append(html);
                                }else {                            
                                    $this.next(".file-preview").append(html);
                                }
                            }
                        } else {
                            $this.find(".file-amount").html("Choose File");
                        }
                    });
            });
            $(document).on('click', '.file-preview-item', function(e) {
                var item_id = $(this).data('id');
                $(this).parent().prev().find('.default-image').val(item_id);
                $(this).parent().find('.file-preview-item').removeClass('selected');
                $(this).addClass('selected');
            });
        },
        seshraUppy: function(group) {
            if ($("#seshra-upload-files").length > 0) {
                var uppy = Uppy.Core({
                    autoProceed: true,
                    restrictions: {
                        maxNumberOfFiles: MEDIA.uploader.data.multiple ? null : 1,
                    },
                    meta: {
                        group: group
                    }
                });
                uppy.use(Uppy.Dashboard, {
                    target: "#seshra-upload-files",
                    inline: true,
                    showLinkToFileUploadResult: false,
                    showProgressDetails: true,
                    hideCancelButton: true,
                    hidePauseResumeButton: true,
                    hideUploadButton: true,
                    proudlyDisplayPoweredByUppy: false
                });
                uppy.use(Uppy.XHRUpload, {
                    endpoint: MEDIA.data.appUrl + "/admin/filemanager/upload",
                    fieldName: "file",
                    formData: true,
                    headers: {
                        'X-CSRF-TOKEN': MEDIA.data.csrf,
                    }
                });
                uppy.on("upload-success", function(file, response) {
                    if (MEDIA.uploader.data.multiple === false) {
                        MEDIA.uploader.data.selectedFiles = [];
                    }
                    MEDIA.uploader.data.selectedFiles.push(response.body.id);
                    MEDIA.uploader.getAllUploads(
                        MEDIA.data.appUrl + "/admin/filemanager/files",
                        group
                    );
                });
                uppy.on('upload-error', (file, error, response) => {
                    const { name } = file;
                    if (response.status === 413) {
                        LARAPRESS.plugins.notify('warning', response.body.message);
                    } else if (response.status == 415) {
                        LARAPRESS.plugins.notify('warning', response.body.message);
                    } else {
                        LARAPRESS.plugins.notify('danger', `Failed in uploading ${name}`);
                    }
                });
            }
        }
    };
    MEDIA.extra = {
        refreshToken: function() {
            $.get(MEDIA.data.appUrl + '/refresh-csrf').done(function(data) {
                MEDIA.data.csrf = data;
            });
            // console.log(MEDIA.data.csrf);
        },
        bytesToSize: function(bytes) {
            var sizes = ["Bytes", "KB", "MB", "GB", "TB"];
            if (bytes == 0) return "0 Byte";
            var i = parseInt(Math.floor(Math.log(bytes) / Math.log(1024)));
            return Math.round(bytes / Math.pow(1024, i), 2) + " " + sizes[i];
        },
        multiModal: function() {
            $(document).on("show.bs.modal", ".modal", function(event) {
                var zIndex = 1040 + 10 * $(".modal:visible").length;
                $(this).css("z-index", zIndex);
                setTimeout(function() {
                    $(".modal-backdrop")
                        .not(".modal-stack")
                        .css("z-index", zIndex - 1)
                        .addClass("modal-stack");
                }, 0);
            });
            $(document).on('hidden.bs.modal', function() {
                if ($('.modal.show').length > 0) {
                    $('body').addClass('modal-open');
                }
            });
        },
        bsCustomFile: function() {
            $(".custom-file input").change(function(e) {
                var files = [];
                for (var i = 0; i < $(this)[0].files.length; i++) {
                    files.push($(this)[0].files[i].name);
                }
                if (files.length === 1) {
                    $(this).next(".custom-file-name").html(files[0]);
                } else if (files.length > 1) {
                    $(this)
                        .next(".custom-file-name")
                        .html(files.length + " Files Selected");
                } else {
                    $(this).next(".custom-file-name").html("Choose file");
                }
            });
        },
        stopPropagation: function() {
            $(document).on('click', '.stop-propagation', function(e) {
                e.stopPropagation();
            });
        },
        outsideClickHide: function() {
            $(document).on('click', function(e) {
                $('.document-click-d-none').addClass('d-none');
            });
        },
        scrollToBottom: function() {
            $(".scroll-to-btm").each(function(i, el) {
                el.scrollTop = el.scrollHeight;
            });
        },
        classToggle: function() {
            $(document).on('click', '[data-toggle="class-toggle"]', function() {
                var $this = $(this);
                var target = $this.data("target");
                var sameTriggers = $this.data("same");

                if ($(target).hasClass("active")) {
                    $(target).removeClass("active");
                    $(sameTriggers).removeClass("active");
                    $this.removeClass("active");
                } else {
                    $(target).addClass("active");
                    $this.addClass("active");
                }
            });
        },
        autoScroll: function() {
            if ($(".seshra-auto-scroll").length > 0) {
                $(".seshra-auto-scroll").each(function() {
                    var options = $(this).data("options");

                    options = !options ?
                        '{"delay" : 2000 ,"amount" : 70 }' :
                        options;

                    options = JSON.parse(options);

                    this.delay = parseInt(options["delay"]) || 2000;
                    this.amount = parseInt(options["amount"]) || 70;
                    this.autoScroll = $(this);
                    this.iScrollHeight = this.autoScroll.prop("scrollHeight");
                    this.iScrollTop = this.autoScroll.prop("scrollTop");
                    this.iHeight = this.autoScroll.height();

                    var self = this;
                    this.timerId = setInterval(function() {
                        if (
                            self.iScrollTop + self.iHeight <
                            self.iScrollHeight
                        ) {
                            self.iScrollTop = self.autoScroll.prop("scrollTop");
                            self.iScrollTop += self.amount;
                            self.autoScroll.animate({ scrollTop: self.iScrollTop },
                                "slow",
                                "linear"
                            );
                        } else {
                            self.iScrollTop -= self.iScrollTop;
                            self.autoScroll.animate({ scrollTop: "0px" },
                                "fast",
                                "swing"
                            );
                        }
                    }, self.delay);
                });
            }
        },
        addMore: function() {
            $('[data-toggle="add-more"]').each(function() {
                var $this = $(this);
                var content = $this.data("content");
                var target = $this.data("target");

                $this.on("click", function(e) {
                    e.preventDefault();
                    $(target).append(content);
                });
            });
        },
        removeParent: function() {
            $(document).on(
                "click",
                '[data-toggle="remove-parent"]',
                function() {
                    var $this = $(this);
                    var parent = $this.data("parent");
                    $this.closest(parent).remove();
                }
            );
        },
        selectHideShow: function() {
            $('[data-show="selectShow"]').each(function() {
                var target = $(this).data("target");
                $(this).on("change", function() {
                    var value = $(this).val();
                    // console.log(value);
                    $(target)
                        .children()
                        .not("." + value)
                        .addClass("d-none");
                    $(target)
                        .find("." + value)
                        .removeClass("d-none");
                });
            });
        },
        trimAppUrl: function() {
            if (MEDIA.data.appUrl.slice(-1) == '/') {
                MEDIA.data.appUrl = MEDIA.data.appUrl.slice(0, MEDIA.data.appUrl.length - 1);
            }
        },
    };

    MEDIA.uploader.initForInput();
    MEDIA.uploader.previewGenerate();
    MEDIA.uploader.removeAttachment();

})(jQuery);