@extends('gear::layouts.master2')
@section('content')
    <div class="bread-crumb">
    	<div class="container">
    		<div class="row">
    			<div class="col-md-12 text-center">
    				<h1>{{ $page->title() }}</h1>
    				<a href="{{url('/')}}">Home</a> > {{ $page->title() }}
    			</div>
    		</div>
    	</div>
    </div>
    
    <div class="services">
		<div class="container">
            <div class="row justify-content-center">
                @php
                    $blogs = posts(16, [
                        'post_type' => 'products',
                    ]);
                @endphp
                @foreach ($blogs as $blog)
                <div class="col-md-3">
					<a href="{{ $blog->permalink() }}">
						<div class="product-img-back">
							<img src="{{ $blog->featuredImage() }}">
						</div>
						<div class="product-price">
							<h3>{!! $blog->subtitle() !!}</h3>
							<h2>{{ $blog->title }}</h2>
						</div>
					</a>
				</div>
                @endforeach
            </div>
        </div>
    </div>

       

@endsection