@extends('gear::layouts.master')
@section('content')
<div class="title-bar">
    <div class="container text-center">
        <h1>{{ $page->title() }}</h1>
        <div class="breadcrumbs">
            <a href="{{ url('/') }}">Home</a> >{{ $page->title() }}
        </div>
    </div>
</div>

<div class="content-page">
    <div class="container">
        <div class="row">
            <div class="col-lg-8">
                @include('includes.partials.messages')
                {!! $page->content() !!}
                <div class="post-metas">
                    @foreach($page->metas()->orderBy('post_meta.sort', 'ASC')->get() as $meta)
                    <div class="row post-meta-block {{$meta->key}}">
                        @for($i = 1; $i <= $meta->pull('cols'); $i++)
                        <div class="col-md-{{$meta->pull('column', 12)}}">
                            @foreach($meta->pull('post') as $item)
                                @if($meta->pull('type') == 'title_block')
                                    <div class="post-meta-item title-block">
                                        <h2 style="text-align: {{$item[$i]['align'] ?? ''}};">{{ $item[$i]['title'] ?? ''}}</h2>
                                    </div>
                                @elseif($meta->pull('type') == 'title_subtitle_block')
                                    <div class="post-meta-item title-subtitle-block">
                                        <h2 style="text-align: {{$item[$i]['align'] ?? ''}};">{{ $item[$i]['title'] ?? ''}}</h2>
                                        <h3 style="text-align: {{$item[$i]['align'] ?? ''}};">{{ $item[$i]['subtitle'] ?? ''}}</h3>
                                    </div>
                                @elseif($meta->pull('type') == 'text_block')
                                    <div class="post-meta-item text-block">
                                        {!! $item[$i]['content'] !!}
                                    </div>
                                @elseif($meta->pull('type') == 'text_block_with_title')
                                    <div class="row post-meta text-block-with-title {{$meta->pull('class')}}" id="{{$meta->pull('id')}}">
                                        <div class="col-md-{{$meta->pull('cols', 12)}}">
                                            <div class="post-meta-title">{{$meta->pull('title')}}</div>
                                            <div class="post-meta-body">
                                                {!! $meta->pull('content') !!}
                                            </div>
                                        </div>
                                    </div>
                                @elseif($meta->pull('type') == 'text_block_title_image')
                                    <div class="row post-meta text-block-title-image {{$meta->pull('class')}}" id="{{$meta->pull('id')}}">
                                        <div class="col-lg-7">
                                            <div class="post-meta-title">{{$meta->pull('title')}}</div>
                                            <div class="post-meta-body">
                                                {!! $meta->pull('content') !!}
                                            </div>
                                        </div>
                                        <div class="col-lg-5">
                                            <img class="post-meta-image" src="{{image($meta->pull('featured_image'))}}">
                                        </div>
                                    </div>
                                @elseif($meta->pull('type') == 'text_list_block')
                                    <div class="row post-meta text-list-block {{$meta->pull('class')}}"  id="{{$meta->pull('id')}}">
                                        @foreach($meta->pull('list') as $item)
                                            <div class="col-lg-{{$meta->pull('cols', 4)}} d-flex">
                                                <div class="meta-list-item">
                                                    <h3 class="post-meta-title">{{$item['key']}}</h3>
                                                    <p>{!! $item['value'] !!}</p>
                                                </div>
                                            </div>
                                        @endforeach
                                    </div>
                                @elseif($meta->pull('type') == 'text_list_block_image')
                                    <div class="row post-meta text-list-block-with-image {{$meta->pull('class')}}"  id="{{$meta->pull('id')}}">
                                        @foreach($meta->pull('list') as $item)
                                            <div class="col-lg-{{$meta->pull('cols', 6)}} d-flex">
                                                <div class="{{$meta->pull('class')}}  meta-list-item " id="{{$meta->pull('id')}}">
                                                    <div class="row">
                                                        <div class="col-sm-8">
                                                            <h2 class="post-meta-title">{{$item['key']}}</h2>
                                                                <p>{!! $item['value'] !!}</p>
                                                            
                                                        </div>
                                                        <div class="col-sm-4 col-9">
                                                            <img src="{{image($item['image'])}}" class="w-100">
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        @endforeach
                                    </div>
                                @elseif($meta->pull('type') == 'list_block_with_title_image_url')
                                    <div class="row post-meta list-block-title-image-url {{$meta->pull('class')}}"  id="{{$meta->pull('id')}}">
                                        @foreach($meta->pull('list') as $item)
                                            <div class="col-lg-{{$meta->pull('cols', 6)}} d-flex">
                                                <div class="{{$meta->pull('class')}}  meta-list-item " id="{{$meta->pull('id')}}">
                                                    <a href="{{$item['url']}}">
                                                    <div class="row">
                                                        <div class="col-sm-8">
                                                            <h2 class="post-meta-title">{{$item['title']}}</h2>
                                                            
                                                        </div>
                                                        <div class="col-sm-4 col-9">
                                                            <img src="{{image($item['image'])}}" class="w-100">
                                                        </div>
                                                    </div>
                                                    </a>
                                                </div>
                                            </div>
                                        @endforeach
                                    </div>                     
                                @endif
                            @endforeach
                        </div>
                        @endfor
                    </div>
                    @endforeach
                </div>
            </div>

        </div>
    </div>
</div>
@endsection