@foreach($items as $item)
  <li@lm-attrs($item) class="nav-item {{($item->hasChildren()) ? 'dropdown' :''}} @lm-endattrs>
    @if($item->link) 
    <a @lm-attrs($item->link) 
     @if($item->hasChildren())
        class="nav-link dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"
     @else 
        class="nav-link" 
     @endif 
     @lm-endattrs href="{{ $item->url() }}">
      {!! $item->title !!}
      @if($item->hasChildren()) <b class="caret"></b> @endif
    </a>
    @else
      {!! $item->title !!}
    @endif
    @if($item->hasChildren())
      <ul class="dropdown-menu">
        @foreach($item->children() as $subitem)
            <li @if($subitem->hasChildren()) class="dropdown-submenu" @endif>
                <a class="dropdown-item" @if($subitem->hasChildren()) tabindex="-1" @endif href="{{$subitem->url() }}">{{$subitem->title}}</a> 
                 @if($subitem->hasChildren())
                     <ul class="dropdown-menu">
                        @foreach($subitem->children() as $subsubitem)
                            <li><a href="{{$subsubitem->url() }}">{{$subsubitem->title}}</a></li>
                        @endforeach
                      </ul>
                 @endif
            </li>
            @endforeach
      </ul> 
    @endif
  </li>
@endforeach