@extends('gear::layouts.master')
@section('content')
    <div class="title-bar">
        <div class="container text-center">
            <h1>{{ $page->title() }}</h1>
            <div class="breadcrumbs">
                <a href="{{url('/')}}">Home</a> >{{ $page->title() }}
            </div>
        </div>
    </div>

    <div class="hospital-section" style="padding-bottom:70px;">
        <div class="container">
            <div class="detailed-section">
                <div class="row">
                    @php
                        $blogs = posts(24, [
                            'post_type' => 'intp',
                        ]);
                    @endphp
                    @foreach ($blogs as $blog)
                        <div class='col-md-3'>
                            <div class='right-photo hospital-single'>
                                <a href="{{ $blog->permalink() }}">
                                    @if ($blog->hasFeaturedImage())
                                        <a href="{{ $blog->permalink() }}" class="image">
                                            <img src="{{ $blog->featuredImage() }}">
                                        </a>
                                    @endif
                                    <h5>{{ $blog->title }}</h5>
                                    <p>{{ $blog->excerpt }}</p>
                                </a>
                            </div>
                        </div>                    
                    @endforeach
                </div>
            </div>
        </div>
    </div>
@endsection