$.ajaxSetup({
    headers: {
        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
    }
});

//custom jquery method for toggle attr
$.fn.toggleAttr = function(attr, attr1, attr2) {
    return this.each(function() {
        var self = $(this);
        if (self.attr(attr) == attr1) self.attr(attr, attr2);
        else self.attr(attr, attr1);
    });
};
Array.prototype.remove = function() {
    var what, a = arguments,
        L = a.length,
        ax;
    while (L && this.length) {
        what = a[--L];
        while ((ax = this.indexOf(what)) !== -1) {
            this.splice(ax, 1);
        }
    }
    return this;
};
(function($) {
    // USE STRICT
    "use strict";

    LARAPRESS.data = {
        csrf: $('meta[name="csrf-token"]').attr("content"),
        appUrl: $('meta[name="app-url"]').attr("content"),
        fileBaseUrl: $('meta[name="file-base-url"]').attr("content"),
        selectedItems: []
    };
    LARAPRESS.plugins = {
        bootstrapSelect: function(refresh = "") {
            $(".seshra-selectpicker").each(function(el) {
                var $this = $(this);
                if (!$this.parent().hasClass('bootstrap-select')) {
                    var selected = $this.data('selected');
                    if (typeof selected !== 'undefined') {
                        $this.val(selected);
                    }
                    $this.selectpicker({
                        size: 5,
                        virtualScroll: false
                    });
                }
                if (refresh === "refresh") {
                    $this.selectpicker("refresh");
                }
                if (refresh === "destroy") {
                    $this.selectpicker("destroy");
                }
            });
        },
        tagify: function() {
            $(".seshra-tag-input").not(".tagify").each(function() {
                var $this = $(this);

                var maxTags = $this.data("max-tags");
                var whitelist = $this.data("whitelist");
                var onchange = $this.data("on-change");
                var keydown = $this.data("keydown");
                var skipInvalid = $this.data("skip-invalid");
                var enforceWhitelist = $this.data("enforce-whitelist");

                maxTags = !maxTags ? Infinity : maxTags;
                whitelist = !whitelist ? [] : whitelist;
                skipInvalid = skipInvalid ? true : false;
                enforceWhitelist = enforceWhitelist ? true : false;
                keydown = keydown ? true : false;

                var tagify = $this.tagify({
                    maxTags: maxTags,
                    whitelist: whitelist,
                    skipInvalid: skipInvalid,
                    enforceWhitelist: enforceWhitelist,
                    dropdown: {
                        maxItems: 20,
                        enabled: 0,
                        closeOnSelect: true
                    }
                });
                try {
                    callback = eval(onchange);
                } catch (e) {
                    var callback = '';
                }
                if (typeof callback == 'function') {
                    $this.on('removeTag', function(e) {
                        callback(e);
                    });
                    $this.on('add', function(e) {
                        callback(e);
                    });
                    if (keydown) {
                        $this.on('input', function(e, taggy) {
                            callback(e, taggy);
                        });
                    }
                }
            });
        },
        textEditor: function() {
            $(".seshra-text-editor").each(function(el) {
                var $this = $(this);
                var buttons = $this.data("buttons");
                var minHeight = $this.data("min-height");
                var placeholder = $this.attr("placeholder");
                var format = $this.data("format");
                var imageUploaderUrl = $this.data("image-submit-url");
                var airmode = $this.data("airmode") ? true : false;
                var imageGroup = $this.data("image-group");
                imageGroup = imageGroup == '' ? 'editor-images' : imageGroup;
                imageUploaderUrl = (imageUploaderUrl == '') ? 'image/upload' : imageUploaderUrl;

                buttons = !buttons ? [
                        ["font", ["bold", "underline", "italic", "clear"]],
                        ["style", ["superscript", "subscript"]],
                        ["para", ["ul", "ol", "paragraph"]],
                        ['fontsize', ['fontsize']],
                        ["header", ["style"]],
                        ["color", ["color"]], 
                        ["table", ["table"]],
                        ["insert", ["link","picture","video"]],
                        ["view", ["fullscreen","codeview"]]
                    ]       
                    :
                    buttons;
                placeholder = !placeholder ? "" : placeholder;
                minHeight = !minHeight ? 200 : minHeight;
                format = (typeof format == 'undefined') ? false : format;
                $this.summernote({
                    toolbar: buttons,
                    placeholder: placeholder,
                    height: minHeight,
                    airMode: airmode,
                    callbacks: {
                        onImageUpload: function(files) {
                            var editor = $(this);
                            uploadImageContent(files[0], editor, imageUploaderUrl, imageGroup);
                        },
                        onPaste: function(e) {
                            if (!format) {
                                var bufferText = ((e.originalEvent || e).clipboardData || window.clipboardData).getData('Text');
                                e.preventDefault();
                                document.execCommand('insertText', false, bufferText);
                            }
                        }
                    }
                });

                var nativeHtmlBuilderFunc = $this.summernote('module', 'videoDialog').createVideoNode;

                $this.summernote('module', 'videoDialog').createVideoNode = function(url) {
                    var wrap = $('<div class="embed-responsive embed-responsive-16by9"></div>');
                    var html = nativeHtmlBuilderFunc(url);
                    html = $(html).addClass('embed-responsive-item');
                    return wrap.append(html)[0];
                };
            });
        },
        dateRange: function() {
            $(".seshra-date-range").each(function() {
                var $this = $(this);
                var today = moment().startOf("day");
                var value = $this.val();
                var startDate = false;
                var minDate = false;
                var maxDate = false;
                var maxSpan = false;
                var advncdRange = false;
                var ranges = {
                    Today: [moment(), moment()],
                    Yesterday: [
                        moment().subtract(1, "days"),
                        moment().subtract(1, "days"),
                    ],
                    "Last 7 Days": [moment().subtract(6, "days"), moment()],
                    "Last 30 Days": [moment().subtract(29, "days"), moment()],
                    "This Month": [
                        moment().startOf("month"),
                        moment().endOf("month"),
                    ],
                    "Last Month": [
                        moment().subtract(1, "month").startOf("month"),
                        moment().subtract(1, "month").endOf("month"),
                    ],
                };

                var single = $this.data("single");
                var monthYearDrop = $this.data("show-dropdown");
                var format = $this.data("format");
                var separator = $this.data("separator");
                var pastDisable = $this.data("past-disable");
                var futureDisable = $this.data("future-disable");
                var timePicker = $this.data("time-picker");
                var timePickerIncrement = $this.data("time-gap");
                var advncdRange = $this.data("advanced-range");
                var maxSpan = $this.data("max-span");

                single = !single ? false : single;
                monthYearDrop = !monthYearDrop ? false : monthYearDrop;
                format = !format ? "YYYY-MM-DD" : format;
                separator = !separator ? " / " : separator;
                minDate = !pastDisable ? minDate : today;
                maxDate = !futureDisable ? maxDate : today;
                timePicker = !timePicker ? false : timePicker;
                timePickerIncrement = !timePickerIncrement ? 1 : timePickerIncrement;
                ranges = !advncdRange ? "" : ranges;
                maxSpan = maxSpan ? { days: maxSpan } : false;
                $this.daterangepicker({
                    singleDatePicker: single,
                    showDropdowns: monthYearDrop,
                    minDate: minDate,
                    maxDate: maxDate,
                    timePickerIncrement: timePickerIncrement,
                    autoUpdateInput: false,
                    ranges: ranges,
                    maxSpan: maxSpan,
                    locale: {
                        format: format,
                        separator: separator,
                        applyLabel: "Select",
                        cancelLabel: "Clear",
                    },
                });
                if (single) {
                    $this.on("apply.daterangepicker", function(ev, picker) {
                        $this.val(picker.startDate.format(format));
                    });
                } else {
                    $this.on("apply.daterangepicker", function(ev, picker) {
                        $this.val(
                            picker.startDate.format(format) +
                            separator +
                            picker.endDate.format(format)
                        );
                    });
                }

                $this.on("cancel.daterangepicker", function(ev, picker) {
                    $this.val("");
                });
            });
        },
        timePicker: function() {
            $(".seshra-time-picker").each(function() {
                var $this = $(this);

                var minuteStep = $this.data("minute-step");
                var defaultTime = $this.data("default");

                minuteStep = !minuteStep ? 10 : minuteStep;
                defaultTime = !defaultTime ? "00:00" : defaultTime;

                $this.timepicker({
                    template: "dropdown",
                    minuteStep: minuteStep,
                    defaultTime: defaultTime,
                    icons: {
                        up: "las la-angle-up",
                        down: "las la-angle-down",
                    },
                    showInputs: false,
                });
            });
        },
        fooTable: function() {
            $(".seshra-table").each(function() {
                var $this = $(this);

                var empty = $this.data("empty");
                empty = !empty ? "Nothing Found" : empty;

                var ft = $this.footable({
                    breakpoints: {
                        xs: 576,
                        sm: 768,
                        md: 992,
                        lg: 1200,
                        xl: 1400,
                    },
                    cascade: true,
                    on: {
                        "ready.ft.table": function(e, ft) {
                            LARAPRESS.plugins.reload('selectable');
                        },
                    },
                    empty: empty,
                });
            });
        },
        notify: function(type = "dark", message = "") {
            $.notify({
                // options
                message: message,
            }, {
                // settings
                showProgressbar: true,
                delay: 2500,
                mouse_over: "pause",
                placement: {
                    from: "bottom",
                    align: "left",
                },
                animate: {
                    enter: "animated fadeInUp",
                    exit: "animated fadeOutDown",
                },
                type: type,
                template: '<div data-notify="container" class="seshra-notify alert alert-{0}" role="alert">' +
                    '<button type="button" aria-hidden="true" data-notify="dismiss" class="close"><i class="las la-times"></i></button>' +
                    '<span data-notify="message">{2}</span>' +
                    '<div class="progress" data-notify="progressbar">' +
                    '<div class="progress-bar" role="progressbar" aria-valuenow="0" aria-valuemin="0" aria-valuemax="100" style="width: 0%;"></div>' +
                    "</div>" +
                    "</div>",
            });
        },
        tooltip: function() {
            $('body').tooltip({ selector: '[data-toggle="tooltip"]' }).click(function() {
                $('[data-toggle="tooltip"]').tooltip("hide");
            });
        },
        selectable: function () {
            $(document).on("click", '.seshra-checkbox-item', function (e) {
                var id = $(this).val();
                if($(this).prop("checked") == true && id != '') {
                    if (!LARAPRESS.data.selectedItems.includes(id)) {
                        LARAPRESS.data.selectedItems.push(id);
                    }
                } else if($(this).prop("checked") == false){
                    if (LARAPRESS.data.selectedItems.includes(id)) {
                        LARAPRESS.data.selectedItems.remove(id);
                    }
                }
            });

            $('#seshra-select-all-items').on("click", function (e) {
                var has_select_all = $(this).prop("checked");
                $('.seshra-checkbox-item').each(function () {
                    var id = $(this).val();
                    if(has_select_all && id != '') {
                        if (!LARAPRESS.data.selectedItems.includes(id)) {
                            $(this).prop("checked", "checked");
                            LARAPRESS.data.selectedItems.push(id);
                        }
                    } else {
                        if (LARAPRESS.data.selectedItems.includes(id)) {
                            $(this).prop("checked", "");
                            LARAPRESS.data.selectedItems.remove(id);
                        }                        
                    }
                });
            });

            $('.seshra-bulk-select-form').on('submit', function(e) {
                e.preventDefault();
                var action = $(this).attr('action');
                if(LARAPRESS.data.selectedItems.length > 0) {
                    if(typeof(action) == 'undefined' || action == null) {
                        var bulk_select = $(this).find('.seshra-bulk-select');
                        var option = bulk_select.val();
                        var action =$('option:selected', bulk_select).attr('action');
                        if(option == 'delete') {
                            Swal.fire({
                                title: 'Are you sure?',
                                text: "You won't be able to revert this!",
                                showCancelButton: true,
                                confirmButtonColor: '#3085d6',
                                confirmButtonText: 'Yes, delete it!',
                              }).then((result) => {
                                if (result.isConfirmed) {
                                    loading();
                                    $.ajax({
                                        type: "POST",
                                        url: action,
                                        data: {items: LARAPRESS.data.selectedItems},
                                        success: function(data) {
                                            if(data.partial_delete) {
                                                Swal.fire(
                                                    'Partially Deleted!',
                                                    data.message,
                                                    'warning'
                                                  )
                                            } else{
                                                Swal.fire(
                                                    'Deleted!',
                                                    'Your file has been deleted.',
                                                    'success'
                                                  )
                                            }
                                            
                                            // location.reload();
                                        },
                                        error: function() {
                                            LARAPRESS.plugins.notify('danger', 'Something went wrong');
                                        },
                                        complete: function() {
                                            loading(false);
                                        }
                                    });
                                }
                              })
                        } else if(option == 'approve_all') {
                            Swal.fire({
                                title: 'Are you sure?',
                                showCancelButton: true,
                                confirmButtonColor: '#28a745',
                                confirmButtonText: 'Yes, Approve all!',
                              }).then((result) => {
                                if (result.isConfirmed) {
                                    loading();
                                    $.ajax({
                                        type: "POST",
                                        url: action,
                                        data: {items: LARAPRESS.data.selectedItems},
                                        success: function(data) {
                                            Swal.fire(
                                                'Approved!',
                                                'Your file has been approved.',
                                                'success'
                                              )
                                            location.reload();
                                        },
                                        error: function() {
                                            LARAPRESS.plugins.notify('danger', 'Something went wrong');
                                        },
                                        complete: function() {
                                            loading(false);
                                        }
                                    });
                                }
                              })
                        }
                    } else {
                        Swal.fire({
                            title: 'Are you sure?',
                            text: "You won't be able to revert this!",
                            showCancelButton: true,
                            confirmButtonColor: '#3085d6',
                            confirmButtonText: 'Yes, delete it!',
                          }).then((result) => {
                            if (result.isConfirmed) {
                                loading();
                                $.ajax({
                                    type: "POST",
                                    url: action,
                                    data: {items: LARAPRESS.data.selectedItems},
                                    success: function(data) {
                                        if(data.partial_delete) {
                                            Swal.fire(
                                                'Partially Deleted!',
                                                data.message,
                                                'warning'
                                              )
                                        } else{
                                            Swal.fire(
                                                'Deleted!',
                                                'Your file has been deleted.',
                                                'success'
                                              )
                                        }
                                        location.reload();
                                    },
                                    error: function() {
                                        LARAPRESS.plugins.notify('danger', 'Something went wrong');
                                    },
                                    complete: function() {
                                        loading(false);
                                    }
                                });
                            }
                          })
                    }
                    
                    
                } else {
                    loading(false);
                    LARAPRESS.plugins.notify('warning', 'Please select at least one item.');
                }
                
            });
        },
        reload: function(plugins=false) {
            if(typeof(plugins) === 'string') {
                if(plugins == 'tag') LARAPRESS.plugins.tagify();
                if(plugins == 'textarea') LARAPRESS.plugins.textEditor();
                if(plugins == 'select') LARAPRESS.plugins.bootstrapSelect('refresh');
                if(plugins == 'table')  LARAPRESS.plugins.fooTable();
                if(plugins == 'daterange')  LARAPRESS.plugins.dateRange();
                if(plugins == 'selectable') LARAPRESS.plugins.selectable();
            }
            if (typeof(plugins) === 'object') {
                if (plugins.includes('tag')) LARAPRESS.plugins.tagify();
                if (plugins.includes('textarea')) LARAPRESS.plugins.textEditor();
                if (plugins.includes('select')) LARAPRESS.plugins.bootstrapSelect('refresh');
                if (plugins.includes('table')) LARAPRESS.plugins.fooTable();
                if (plugins.includes('daterange')) LARAPRESS.plugins.dateRange();
                if (plugins.includes('selectable')) LARAPRESS.plugins.selectable();
            }
        }
    };
    LARAPRESS.extra = {
        refreshToken: function() {
            $.get(LARAPRESS.data.appUrl + '/refresh-csrf').done(function(data) {
                LARAPRESS.data.csrf = data;
            });
            // console.log(LARAPRESS.data.csrf);
        },
        mobileNavToggle: function() {
            $('[data-toggle="seshra-mobile-nav"]').on("click", function() {
                if (!$(".seshra-sidebar-wrap").hasClass("open")) {
                    $(".seshra-sidebar-wrap").addClass("open");
                } else {
                    $(".seshra-sidebar-wrap").removeClass("open");
                }
            });
            $(".seshra-sidebar-overlay").on("click", function() {
                $(".seshra-sidebar-wrap").removeClass("open");
            });
        },
        bytesToSize: function(bytes) {
            var sizes = ["Bytes", "KB", "MB", "GB", "TB"];
            if (bytes == 0) return "0 Byte";
            var i = parseInt(Math.floor(Math.log(bytes) / Math.log(1024)));
            return Math.round(bytes / Math.pow(1024, i), 2) + " " + sizes[i];
        },
        multiModal: function() {
            $(document).on("show.bs.modal", ".modal", function(event) {
                var zIndex = 1040 + 10 * $(".modal:visible").length;
                $(this).css("z-index", zIndex);
                setTimeout(function() {
                    $(".modal-backdrop")
                        .not(".modal-stack")
                        .css("z-index", zIndex - 1)
                        .addClass("modal-stack");
                }, 0);
            });
            $(document).on('hidden.bs.modal', function() {
                if ($('.modal.show').length > 0) {
                    $('body').addClass('modal-open');
                }
            });
        },
        bsCustomFile: function() {
            $(".custom-file input").change(function(e) {
                var files = [];
                for (var i = 0; i < $(this)[0].files.length; i++) {
                    files.push($(this)[0].files[i].name);
                }
                if (files.length === 1) {
                    $(this).next(".custom-file-name").html(files[0]);
                } else if (files.length > 1) {
                    $(this)
                        .next(".custom-file-name")
                        .html(files.length + " Files Selected");
                } else {
                    $(this).next(".custom-file-name").html("Choose file");
                }
            });
        },
        stopPropagation: function() {
            $(document).on('click', '.stop-propagation', function(e) {
                e.stopPropagation();
            });
        },
        outsideClickHide: function() {
            $(document).on('click', function(e) {
                $('.document-click-d-none').addClass('d-none');
            });
        },
        scrollToBottom: function() {
            $(".scroll-to-btm").each(function(i, el) {
                el.scrollTop = el.scrollHeight;
            });
        },
        classToggle: function() {
            $(document).on('click', '[data-toggle="class-toggle"]', function() {
                var $this = $(this);
                var target = $this.data("target");
                var sameTriggers = $this.data("same");

                if ($(target).hasClass("active")) {
                    $(target).removeClass("active");
                    $(sameTriggers).removeClass("active");
                    $this.removeClass("active");
                } else {
                    $(target).addClass("active");
                    $this.addClass("active");
                }
            });
        },
        autoScroll: function() {
            if ($(".seshra-auto-scroll").length > 0) {
                $(".seshra-auto-scroll").each(function() {
                    var options = $(this).data("options");

                    options = !options ?
                        '{"delay" : 2000 ,"amount" : 70 }' :
                        options;

                    options = JSON.parse(options);

                    this.delay = parseInt(options["delay"]) || 2000;
                    this.amount = parseInt(options["amount"]) || 70;
                    this.autoScroll = $(this);
                    this.iScrollHeight = this.autoScroll.prop("scrollHeight");
                    this.iScrollTop = this.autoScroll.prop("scrollTop");
                    this.iHeight = this.autoScroll.height();

                    var self = this;
                    this.timerId = setInterval(function() {
                        if (
                            self.iScrollTop + self.iHeight <
                            self.iScrollHeight
                        ) {
                            self.iScrollTop = self.autoScroll.prop("scrollTop");
                            self.iScrollTop += self.amount;
                            self.autoScroll.animate({ scrollTop: self.iScrollTop },
                                "slow",
                                "linear"
                            );
                        } else {
                            self.iScrollTop -= self.iScrollTop;
                            self.autoScroll.animate({ scrollTop: "0px" },
                                "fast",
                                "swing"
                            );
                        }
                    }, self.delay);
                });
            }
        },
        addMore: function() {
            $('[data-toggle="add-more"]').each(function() {
                var $this = $(this);
                var content = $this.data("content");
                var target = $this.data("target");

                $this.on("click", function(e) {
                    e.preventDefault();
                    $(target).append(content);
                });
            });
        },
        removeParent: function() {
            $(document).on(
                "click",
                '[data-toggle="remove-parent"]',
                function() {
                    var $this = $(this);
                    var parent = $this.data("parent");
                    $this.closest(parent).remove();
                }
            );
        },
        selectHideShow: function() {
            $('[data-show="selectShow"]').each(function() {
                var target = $(this).data("target");
                $(this).on("change", function() {
                    var value = $(this).val();
                    // console.log(value);
                    $(target)
                        .children()
                        .not("." + value)
                        .addClass("d-none");
                    $(target)
                        .find("." + value)
                        .removeClass("d-none");
                });
            });
        },
        trimAppUrl: function() {
            if (LARAPRESS.data.appUrl.slice(-1) == '/') {
                LARAPRESS.data.appUrl = LARAPRESS.data.appUrl.slice(0, LARAPRESS.data.appUrl.length - 1);
                // console.log(LARAPRESS.data.appUrl);
            }
        },
    };

    setInterval(function() {
        LARAPRESS.extra.refreshToken();
    }, 3600000);

    // init larapress plugins, extra options
    LARAPRESS.extra.mobileNavToggle();
    LARAPRESS.extra.multiModal();
    LARAPRESS.extra.bsCustomFile();
    LARAPRESS.extra.stopPropagation();
    LARAPRESS.extra.outsideClickHide();
    LARAPRESS.extra.scrollToBottom();
    LARAPRESS.extra.classToggle();
    LARAPRESS.extra.autoScroll();
    LARAPRESS.extra.addMore();
    LARAPRESS.extra.removeParent();
    LARAPRESS.extra.selectHideShow();
    LARAPRESS.extra.trimAppUrl();

    LARAPRESS.plugins.bootstrapSelect();
    LARAPRESS.plugins.tagify();
    LARAPRESS.plugins.textEditor();
    LARAPRESS.plugins.tooltip();
    LARAPRESS.plugins.dateRange();
    LARAPRESS.plugins.timePicker();
    LARAPRESS.plugins.fooTable();


})(jQuery);